import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OrderInputEditorNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import OrderInputEditorRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OrderInputEditor extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OrderInputEditorNotifier(this);
		this.requester = new OrderInputEditorRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal center flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646127696" layout="vertical" width="100px" height="-1px">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a646127696.a_62037836" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_890591461" layout="vertical flexible">
					<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_890591461.a_1860246990" mode="normal">
					</UiTextEditable>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OrderInputEditor));
DisplayFactory.register("OrderInputEditor", withStyles(styles, { withTheme: true })(withSnackbar(OrderInputEditor)));