import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiCloseDialog from "alexandria-ui-elements/src/displays/components/CloseDialog";
import DisplaysOrderTypeItem from "monet-elements/gen/displays/items/OrderTypeItem";
import DisplaysOrderInputEditor from "monet-elements/gen/displays/templates/OrderInputEditor";
import DisplaysOrderTemplate from "monet-elements/gen/displays/templates/OrderTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OrderTypesTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import OrderTypesTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OrderTypesTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OrderTypesTemplateNotifier(this);
		this.requester = new OrderTypesTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504" format="spaced" layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338" format="centered" layout="horizontal" width="80.0%" height="100.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338.a_1828160689" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338.a_1828160689.a_951285869" format="bottomSpaced airBottom bottomBordered" layout="horizontal center">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338.a_1828160689.a_951285869.a1479617977" title="Refresh" target="self" mode="Button" size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338.a_1828160689.a942610436" layout="vertical flexible">
								<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1853466504.a932133338.a_1828160689.a942610436.a_1054781392" pageSize={20} itemHeight={70} scrollingMark={true} selection="single">
								</UiList>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636" title="Fill inputs">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a747853948" layout="vertical flexible" width="100.0%" height="calc(100% - 45px)">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a747853948.a337524260" multiple={{instances:"inputs",arrangement:"Vertical",noItemsMessage:"",spacing:8,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a400078716">
					</UiDivider>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a_180040748" layout="horizontal endjustified">
						<UiCloseDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a_180040748.a_353371196" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
						</UiCloseDialog>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1164375636.a_180040748.a1025528813" title="Accept" target="self" mode="Button" size="Medium" format="airRight">
						</UiAction>
					</UiBlock>
				</UiDialog>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1422675638" title="Order type dialog" fullscreen={true}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1422675638.a1735948534" layout="vertical flexible" width="100.0%" height="100.0%">
						<DisplaysOrderTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1422675638.a1735948534.a1058046675">
						</DisplaysOrderTemplate>
					</UiBlock>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OrderTypesTemplate));
DisplayFactory.register("OrderTypesTemplate", withStyles(styles, { withTheme: true })(withSnackbar(OrderTypesTemplate)));