import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAppDirectory from "alexandria-ui-elements/src/displays/components/AppDirectory";
import UiUser from "alexandria-ui-elements/src/displays/components/User";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HeaderNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HeaderRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Header extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HeaderNotifier(this);
		this.requester = new HeaderRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="whiteBackground middleAirBottom" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190" format="centered airLeft airRight bottomBordered headerHeight" layout="horizontal" width="calc(100% - 20px)" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1678295326" layout="horizontal flexible">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1678295326.a1306346859" format="airRight smallAirTop" mobileReduceFactor={75}>
						</UiImage>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1678295326.a156860370" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1678295326.a156860370.a_1181925292" format="h3 appTitleStyle" visible={false} mode="normal">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1678295326.a156860370.a_1798884104" format="appDescriptionStyle" visible={false} mode="normal">
							</UiText>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1487023361" layout="horizontal center endjustified">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1487023361.a66784870" format="middleAirRight" visible={false} layout="vertical">
							<UiAppDirectory context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1487023361.a66784870.a1807796738" icon="Apps">
							</UiAppDirectory>
						</UiBlock>
						<UiUser context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1487023361.a_2022325836" color="grey" mode="OnlyPhoto">
						</UiUser>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Header));
DisplayFactory.register("Header", withStyles(styles, { withTheme: true })(withSnackbar(Header)));