import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "monet-elements/gen/displays/templates/Header";
import DisplaysOrderTypesTemplate from "monet-elements/gen/displays/templates/OrderTypesTemplate";
import DisplaysOrderTemplate from "monet-elements/gen/displays/templates/OrderTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import AppTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import AppTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class AppTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new AppTemplateNotifier(this);
		this.requester = new AppTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="calc(100% - 10px)" style={{...this.props.style,...display}}>
				<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a795989040">
				</DisplaysHeader>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a_1240687970" layout="vertical flexible centercenter">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a_1240687970.a_1667665322" format="secondary" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a9211736" layout="horizontal flexible">
						<DisplaysOrderTypesTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a9211736.a518467025">
						</DisplaysOrderTypesTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a_90574881" layout="horizontal flexible">
						<DisplaysOrderTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1221189774.a_90574881.a_1774927499">
						</DisplaysOrderTemplate>
					</UiBlockConditional>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate));
DisplayFactory.register("AppTemplate", withStyles(styles, { withTheme: true })(withSnackbar(AppTemplate)));