/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.util;

import io.intino.alexandria.Timetag;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Locale;

public class Formatters {
    private static final String ShortDateFormat = "dd/MM/yyyy HH:mm:ss";

    public static Instant instantOf(Timetag periodo) {
        return periodo.datetime().plusHours(7L).toInstant(OffsetDateTime.now().getOffset());
    }

    public static String shortDate(Instant date) {
        if (date == null) {
            return null;
        }
        return Formatters.formatDate(ShortDateFormat, date);
    }

    private static String formatDate(String pattern, Instant instant) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, new Locale("es", "ES"));
        return format.format(Date.from(instant));
    }
}

