/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.bpm.BpmViewer;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.displays.DisplayHelper;
import io.intino.matisse.box.ui.displays.templates.AbstractProcessView;
import io.intino.matisse.box.ui.displays.templates.ProcessItemDataView;
import java.util.Map;
import java.util.function.Consumer;

public class ProcessView
extends AbstractProcessView<MatisseBox> {
    private Application application;
    private BpmViewer.ProcessInfo process;
    private Consumer<BpmViewer.ProcessInfo> abortListener;

    public ProcessView(MatisseBox box) {
        super(box);
    }

    public ProcessView application(Application application) {
        this.application = application;
        return this;
    }

    public ProcessView process(BpmViewer.ProcessInfo process) {
        this.process = process;
        return this;
    }

    public ProcessView onAbort(Consumer<BpmViewer.ProcessInfo> listener) {
        this.abortListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.abort.onExecute(e -> this.abort());
        this.detailsDialog.onOpen(e -> this.refreshDetailsDialog());
    }

    public void refresh() {
        super.refresh();
        this.refreshProperties();
        this.refreshExtraData();
        this.refreshData();
        this.refreshMessages();
        this.refreshDefinition();
    }

    private void refreshProperties() {
        this.title.value(DisplayHelper.label(this.process));
        this.subtitle.value(DisplayHelper.type(this.process));
        this.processId.value(this.process.id());
        this.abort.visible(!this.process.isFinished());
    }

    private void refreshExtraData() {
        this.extraData.clear();
        this.fill(this.translate("Start date"), DisplayHelper.startDate(this.process), (ProcessItemDataView)this.extraData.add());
        this.fill(this.translate("Finish date"), DisplayHelper.endDate(this.process), (ProcessItemDataView)this.extraData.add());
    }

    private void refreshData() {
        this.data.clear();
        this.process.data().entrySet().forEach(entry -> this.fill((Map.Entry<String, String>)entry, (ProcessItemDataView)this.data.add()));
    }

    private void refreshMessages() {
        this.messagesStamp.application(this.application);
        this.messagesStamp.process(this.process);
        this.messagesStamp.refresh();
    }

    private void refreshDefinition() {
        this.definitionStamp.application(this.application);
        this.definitionStamp.process(this.process);
        this.definitionStamp.refresh();
    }

    private void refreshDetailsDialog() {
        this.detailsDialog.title(this.translate("Details of") + " " + DisplayHelper.label(this.process));
        this.refreshEditor();
    }

    private void refreshEditor() {
        this.editorStamp.application(this.application);
        this.editorStamp.process(this.process);
        this.editorStamp.refresh();
    }

    private void fill(Map.Entry<String, String> entry, ProcessItemDataView view) {
        this.fill(entry.getKey(), entry.getValue(), view);
    }

    private void fill(String name, String value, ProcessItemDataView view) {
        view.name.value(name);
        view.value.value(value);
    }

    private void abort() {
        ((MatisseBox)this.box()).actionDispatcher().abortProcess(this.application, this.process, this.username());
        this.notifyUser("Process have been aborted. It have been archived. You can find it by navigating to finished tab", UserMessage.Type.Success);
        this.abortListener.accept(this.process);
    }
}

