/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.bpm.BpmViewer;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.datasources.ProcessDatasources;
import io.intino.matisse.box.ui.displays.DisplayHelper;
import io.intino.matisse.box.ui.displays.items.FinishedProcessViewItem;
import io.intino.matisse.box.ui.displays.templates.AbstractFinishedProcessCatalog;
import io.intino.matisse.box.ui.displays.templates.ProcessItemDataView;
import io.intino.matisse.util.Formatters;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;

public class FinishedProcessCatalog
extends AbstractFinishedProcessCatalog<MatisseBox> {
    private Application application;
    private String condition;
    private Timetag timetag = Timetag.of((Instant)Instant.now(), (Scale)Scale.Month);

    public FinishedProcessCatalog(MatisseBox box) {
        super(box);
    }

    public FinishedProcessCatalog application(Application application) {
        this.application = application;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initTemporalSlider();
        this.initList();
    }

    public FinishedProcessCatalog search(String condition) {
        this.condition = condition;
        this.finishedProcessList.filter(condition);
        return this;
    }

    public FinishedProcessCatalog reload() {
        if (this.finishedProcessList.source() == null) {
            this.finishedProcessList.source((PageDatasource)ProcessDatasources.finished((MatisseBox)this.box(), this.session(), this.application));
        } else {
            this.finishedProcessList.reload();
        }
        this.reloadTemporalSlider();
        return this;
    }

    private void initTemporalSlider() {
        this.timetagSlider.onChange(e -> this.selectTimetag((Instant)e.value()));
        this.timetagSlider.formatter(value -> Timetag.of((LocalDateTime)LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC), (Scale)Scale.Month).label());
    }

    private void initList() {
        this.finishedProcessList.onAddItem(event -> {
            BpmViewer.ProcessInfo process = (BpmViewer.ProcessInfo)event.item();
            FinishedProcessViewItem view = (FinishedProcessViewItem)event.component();
            view.title.address(path -> path.replace(":name", this.application.name()).replace(":timetag", this.timetag.toString()).replace(":process", process.id()));
            view.title.title(DisplayHelper.label(process));
            view.subtitle.value(DisplayHelper.type(process));
            view.processId.value(DisplayHelper.label(process).equals(process.id()) ? null : process.id());
            this.refreshExtraData(process, view);
        });
    }

    private void refreshExtraData(BpmViewer.ProcessInfo process, FinishedProcessViewItem view) {
        view.extraData.clear();
        this.fill(this.translate("Start date"), DisplayHelper.startDate(process), (ProcessItemDataView)view.extraData.add());
        this.fill(this.translate("Finish date"), DisplayHelper.endDate(process), (ProcessItemDataView)view.extraData.add());
    }

    private void reloadTemporalSlider() {
        List<Timetag> timetagList = this.application.finishedTimetags();
        Collections.reverse(timetagList);
        Instant min = timetagList.size() > 0 ? Formatters.instantOf(timetagList.get(0)) : Instant.now();
        Instant max = timetagList.size() > 0 ? Formatters.instantOf(timetagList.get(timetagList.size() - 1)) : Instant.now();
        this.timetagSlider.range(min, max);
        this.timetagSlider.value(max);
    }

    private void selectTimetag(Instant instant) {
        this.timetag = new Timetag(instant, Scale.Month);
        this.finishedProcessList.filter(this.timetag);
    }

    private void fill(String name, String value, ProcessItemDataView view) {
        view.name.value(name);
        view.value.value(value);
    }
}

