/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays;

import io.intino.alexandria.bpm.BpmViewer;
import io.intino.alexandria.bpm.ProcessStatus;
import io.intino.matisse.util.Formatters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisplayHelper {
    public static final int DataSamplingSize = 5;

    public static Map<String, String> slice(Map<String, String> data) {
        if (data.size() <= 5) {
            return data;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        for (Map.Entry<String, String> item : data.entrySet()) {
            if (i >= 5) {
                return result;
            }
            result.put(item.getKey(), item.getValue());
            ++i;
        }
        return data;
    }

    public static String label(BpmViewer.ProcessInfo process) {
        return process.data().getOrDefault("label$", process.id());
    }

    public static String type(BpmViewer.ProcessInfo process) {
        return process.data().getOrDefault("type$", process.name());
    }

    public static String startDate(BpmViewer.ProcessInfo process) {
        List processStatuses = process.processStatuses();
        if (processStatuses.size() <= 0) {
            return "-";
        }
        return Formatters.shortDate(((ProcessStatus)processStatuses.get(0)).ts());
    }

    public static String endDate(BpmViewer.ProcessInfo process) {
        List processStatuses = process.processStatuses();
        if (processStatuses.size() <= 0) {
            return "-";
        }
        ProcessStatus status = (ProcessStatus)processStatuses.get(processStatuses.size() - 1);
        if (!status.processStatus().equalsIgnoreCase("aborted") && !status.processStatus().equalsIgnoreCase("exit")) {
            return "-";
        }
        return Formatters.shortDate(status.ts());
    }
}

