/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if (address.length() <= 1) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("applicationProcesses"))) {
            this.dispatchApplicationProcesses(soul, params.get(0));
            return;
        }
        if (address.matches(patterns.get("applicationProcess"))) {
            this.dispatchApplicationProcess(soul, params.get(0), params.get(1), params.get(2));
            return;
        }
        if (address.length() <= 1) {
            this.dispatchError(soul);
            return;
        }
        if (address.matches(patterns.get("error"))) {
            this.dispatchError(soul);
            return;
        }
    }

    public abstract void dispatchHome(Soul var1);

    public abstract void dispatchApplicationProcesses(Soul var1, String var2);

    public abstract void dispatchApplicationProcess(Soul var1, String var2, String var3, String var4);

    public abstract void dispatchError(Soul var1);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("applicationProcesses", "\\/application\\/([^\\/]*)");
        patterns.put("applicationProcess", "\\/application\\/([^\\/]*)\\/process\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("error", "\\/error");
    }

    private String patternOf(String address) {
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("applicationProcesses"))) {
            return patterns.get("applicationProcesses");
        }
        if (address.matches(patterns.get("applicationProcess"))) {
            return patterns.get("applicationProcess");
        }
        if (address.matches(patterns.get("error"))) {
            return patterns.get("error");
        }
        if (address.matches(patterns.get("error"))) {
            return patterns.get("error");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }
}

