/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.datasources;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.bpm.BpmViewer;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalPageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.datasources.ProcessMessage;
import io.intino.matisse.util.ProcessHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessDatasources {
    public static PageDatasource<BpmViewer.ProcessInfo> active(final MatisseBox box, final UISession session, final Application application) {
        return new PageDatasource<BpmViewer.ProcessInfo>(){

            public List<BpmViewer.ProcessInfo> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
                List<BpmViewer.ProcessInfo> processes = ProcessDatasources.filter(application.activeProcesses(), condition, filters);
                int from = Math.min(start, processes.size());
                int end = Math.min(start + count, processes.size());
                return processes.subList(from, end);
            }

            public long itemCount(String condition, List<Filter> filters) {
                return ProcessDatasources.filter(application.activeProcesses(), condition, filters).size();
            }

            public List<Group> groups(String key) {
                return ProcessDatasources.groups(box, session, key);
            }
        };
    }

    public static TemporalPageDatasource<BpmViewer.ProcessInfo> finished(final MatisseBox box, final UISession session, final Application application) {
        return new TemporalPageDatasource<BpmViewer.ProcessInfo>(){

            public List<BpmViewer.ProcessInfo> items(Timetag timetag, int start, int count, String condition, List<Filter> filters, List<String> sortings) {
                List<BpmViewer.ProcessInfo> processes = ProcessDatasources.filter(application.finishedProcesses(timetag), condition, filters);
                int from = Math.min(start, processes.size());
                int end = Math.min(start + count, processes.size());
                return processes.subList(from, end);
            }

            public long itemCount(Timetag timetag, String condition, List<Filter> filters) {
                return ProcessDatasources.filter(application.finishedProcesses(timetag), condition, filters).size();
            }

            public List<Group> groups(String key) {
                return ProcessDatasources.groups(box, session, key);
            }
        };
    }

    public static PageDatasource<ProcessMessage> messages(final MatisseBox box, final UISession session, final BpmViewer.ProcessInfo process) {
        return new PageDatasource<ProcessMessage>(){

            public List<ProcessMessage> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
                List<ProcessMessage> messages = ProcessDatasources.filterMessages(ProcessHelper.messagesOf(process), condition, filters);
                int from = Math.min(start, messages.size());
                int end = Math.min(start + count, messages.size());
                return messages.subList(from, end);
            }

            public long itemCount(String condition, List<Filter> filters) {
                return ProcessDatasources.filterMessages(ProcessHelper.messagesOf(process), condition, filters).size();
            }

            public List<Group> groups(String key) {
                return ProcessDatasources.groups(box, session, key);
            }
        };
    }

    private static List<Group> groups(MatisseBox box, UISession session, String key) {
        return Collections.emptyList();
    }

    private static List<BpmViewer.ProcessInfo> filter(List<BpmViewer.ProcessInfo> processList, String condition, List<Filter> filters) {
        processList = ProcessDatasources.filterProcessesCondition(processList, condition);
        ProcessDatasources.sortProcesses(processList);
        return processList;
    }

    private static List<ProcessMessage> filterMessages(List<ProcessMessage> messageList, String condition, List<Filter> filters) {
        messageList = ProcessDatasources.filterMessagesCondition(messageList, condition);
        ProcessDatasources.sortMessages(messageList);
        return messageList;
    }

    private static List<BpmViewer.ProcessInfo> filterProcessesCondition(List<BpmViewer.ProcessInfo> processList, String condition) {
        if (condition == null || condition.isEmpty()) {
            return processList;
        }
        String[] lowerConditions = condition.toLowerCase().split(" ");
        return processList.stream().filter(process -> Arrays.stream(lowerConditions).allMatch(c -> ProcessDatasources.check(process, c))).collect(Collectors.toList());
    }

    private static List<ProcessMessage> filterMessagesCondition(List<ProcessMessage> messageList, String condition) {
        if (condition == null || condition.isEmpty()) {
            return messageList;
        }
        String[] lowerConditions = condition.toLowerCase().split(" ");
        return messageList.stream().filter(message -> Arrays.stream(lowerConditions).allMatch(c -> ProcessDatasources.check(message, c))).collect(Collectors.toList());
    }

    private static boolean check(BpmViewer.ProcessInfo process, String condition) {
        return process.id().toLowerCase().contains(condition) || process.data().values().stream().anyMatch(d -> d.toLowerCase().contains(condition));
    }

    private static boolean check(ProcessMessage message, String condition) {
        return message.name().toLowerCase().contains(condition);
    }

    private static void sortProcesses(List<BpmViewer.ProcessInfo> result) {
        result.sort(Comparator.comparing(BpmViewer.ProcessInfo::id));
    }

    private static void sortMessages(List<ProcessMessage> result) {
        result.sort((o1, o2) -> o2.enter().compareTo(o1.enter()));
    }
}

