/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.matisse.box.I18n;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.MatisseConfiguration;
import io.intino.matisse.box.ui.AppElementsService;
import io.intino.matisse.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected MatisseConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private PushService pushService;

    public AbstractBox(String[] args) {
        this(new MatisseConfiguration(args));
    }

    public AbstractBox(MatisseConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public MatisseConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.start();
        }
        this.initUI();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initMessageHub();
        this.initTerminal();
        this.initSentinels();
        this.initMessagingServices();
        this.initSlackBots();
        this.initWorkflow();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stop();
        }
        AlexandriaSparkBuilder.instance().stop();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public abstract void afterStop();

    public PushService pushService() {
        return this.pushService;
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    public void setupUi() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        this.authService = this.authService(this.url(this.configuration().get("federation_url")));
        AlexandriaSparkBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/");
        AlexandriaSparkBuilder.setUI((boolean)true);
        AlexandriaSparkBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = new PushService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        AppElementsService.init(sparkInstance, (MatisseBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays((UISpark)sparkInstance, (PushService)this.pushService);
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupUi();
        this.initTranslatorService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        sparkInstance.start();
        io.intino.alexandria.logger.Logger.info((String)"UI AppElements: started!");
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    private void initDatalake() {
    }

    private void initMessageHub() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
    }

    private void initWorkflow() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    private URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

