/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.bpm.BpmViewer;
import io.intino.alexandria.bpm.PersistenceManager;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class Application {
    private final String name;
    private final String label;
    private final PersistenceManager.FilePersistenceManager persistenceManager;
    private final BpmViewer viewer;

    public Application(String name, String label, File workflowDirectory) {
        this.name = name;
        this.label = label;
        this.persistenceManager = new PersistenceManager.FilePersistenceManager(workflowDirectory);
        this.viewer = new BpmViewer((PersistenceManager)this.persistenceManager);
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public List<BpmViewer.ProcessInfo> activeProcesses() {
        return this.viewer.activeProcesses();
    }

    public List<BpmViewer.ProcessInfo> finishedProcesses(Timetag timetag) {
        return this.viewer.finishedProcesses(timetag);
    }

    public List<Timetag> finishedTimetags() {
        return this.persistenceManager.finishedTimetags();
    }

    public String processContent(BpmViewer.ProcessInfo processInfo) {
        try {
            return IOUtils.toString((InputStream)this.persistenceManager.read(processInfo.processPath()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public BpmViewer.ProcessInfo findProcess(Timetag timetag, String id) {
        BpmViewer.ProcessInfo result = this.findIn(this.activeProcesses(), id);
        return result != null ? result : this.findIn(this.finishedProcesses(timetag), id);
    }

    private BpmViewer.ProcessInfo findIn(List<BpmViewer.ProcessInfo> list, String id) {
        return list.stream().filter(p -> p.id().equals(id)).findFirst().orElse(null);
    }
}

