/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.bpm.BpmViewer;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.datasources.ProcessDatasources;
import io.intino.matisse.box.ui.datasources.ProcessMessage;
import io.intino.matisse.box.ui.displays.rows.ProcessMessagesTableRow;
import io.intino.matisse.box.ui.displays.templates.AbstractProcessMessagesTemplate;

public class ProcessMessagesTemplate
extends AbstractProcessMessagesTemplate<MatisseBox> {
    private Application application;
    private BpmViewer.ProcessInfo process;

    public ProcessMessagesTemplate(MatisseBox box) {
        super(box);
    }

    public ProcessMessagesTemplate application(Application application) {
        this.application = application;
        return this;
    }

    public ProcessMessagesTemplate process(BpmViewer.ProcessInfo process) {
        this.process = process;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.processMessagesTable.onAddItem(e -> {
            ProcessMessage message = (ProcessMessage)e.item();
            ProcessMessagesTableRow row = (ProcessMessagesTableRow)e.component();
            row.pmtNameItem.name.value(message.name());
            row.pmtNameItem.status.value(message.exit() == null ? "P" : null);
            row.pmtNameItem.status.backgroundColor("blue");
            row.pmtEnterItem.enter.value(message.enter());
            row.pmtExitItem.exit.value(message.exit());
        });
    }

    public void refresh() {
        super.refresh();
        this.processMessagesTable.source(ProcessDatasources.messages((MatisseBox)this.box(), this.session(), this.process));
    }
}

