/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.bpm.BpmViewer;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.displays.templates.AbstractProcessListTemplate;
import io.intino.matisse.box.ui.displays.templates.ActiveProcessCatalog;
import io.intino.matisse.box.ui.displays.templates.FinishedProcessCatalog;
import java.util.function.Consumer;

public class ProcessListTemplate
extends AbstractProcessListTemplate<MatisseBox> {
    private Application application;
    private Consumer<String> openApplicationListener;
    private String condition;
    private int selectedCatalog = -1;

    public ProcessListTemplate(MatisseBox box) {
        super(box);
    }

    public ProcessListTemplate application(Application application) {
        if (this.application != null && this.application.name().equals(application.name())) {
            return this;
        }
        this.application = application;
        this.catalogSelector.select(0);
        return this;
    }

    public ProcessListTemplate onOpenApplication(Consumer<String> listener) {
        this.openApplicationListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initSelector();
        this.initCatalogs();
        this.initDialog();
    }

    public void refresh() {
        super.refresh();
        this.openSearch();
        this.refreshSelector();
    }

    private void refreshSelector() {
        this.applicationCombo.select(new String[]{this.application.label()});
    }

    private void initSelector() {
        this.applicationCombo.onSelect(e -> this.openApplicationListener.accept((String)e.selection().get(0)));
        ((MatisseBox)this.box()).applications().forEach(a -> this.applicationCombo.add(a.label()));
    }

    private void initCatalogs() {
        this.activeProcessBlock.onShow(e -> this.reloadActiveCatalog());
        this.finishedProcessBlock.onShow(e -> this.reloadFinishedCatalog());
    }

    private void initDialog() {
        this.processDialog.onSearch(this::filter);
    }

    public void openCatalog() {
        this.openSearch();
    }

    public void open(Timetag timetag, String id) {
        this.openProcess(timetag, id);
    }

    private void openSearch() {
        this.processView.hide();
        this.activeProcessBlock.activeProcessCatalog.reload();
    }

    private void openProcess(Timetag timetag, String id) {
        BpmViewer.ProcessInfo process = this.application.findProcess(timetag, id);
        if (process == null) {
            return;
        }
        this.processView.application(this.application);
        this.processView.process(process);
        this.processView.onAbort(p -> this.openCatalog());
        this.processView.show();
        this.processView.refresh();
    }

    private void filter(String condition) {
        this.condition = condition;
        if (this.activeProcessBlock.isVisible()) {
            this.activeProcessBlock.activeProcessCatalog.search(condition);
        } else {
            this.finishedProcessBlock.finishedProcessCatalog.search(condition);
        }
    }

    private BpmViewer.ProcessInfo processOf(String id) {
        return this.application.activeProcesses().stream().filter((? super T p) -> p.id().equals(id)).findFirst().orElse(null);
    }

    private void reloadActiveCatalog() {
        ActiveProcessCatalog catalog = this.activeProcessBlock.activeProcessCatalog;
        catalog.application(this.application);
        if (this.condition != null) {
            catalog.search(this.condition);
        } else {
            catalog.reload();
        }
    }

    private void reloadFinishedCatalog() {
        FinishedProcessCatalog catalog = this.finishedProcessBlock.finishedProcessCatalog;
        catalog.application(this.application);
        if (this.condition != null) {
            catalog.search(this.condition);
        } else {
            catalog.reload();
        }
    }
}

