/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.displays.notifiers.ApplicationTemplateNotifier;
import io.intino.matisse.box.ui.displays.templates.AbstractApplicationTemplate;

public class ApplicationTemplate
extends AbstractApplicationTemplate<MatisseBox> {
    private Application application;

    public ApplicationTemplate(MatisseBox box) {
        super(box);
    }

    public ApplicationTemplate application(Application application) {
        this.application = application;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initSelector();
    }

    public void refresh() {
        super.refresh();
        this.refreshVisibility();
        this.refreshSelector();
        this.refreshApplication();
    }

    public ApplicationTemplate openProcess(Timetag timetag, String id) {
        this.processListStamp.open(timetag, id);
        return this;
    }

    private void initSelector() {
        this.applicationMenu.onSelect(e -> this.open((String)e.selection().get(0)));
        ((MatisseBox)this.box()).applications().forEach(a -> this.applicationMenu.add(a.label()));
    }

    private void refreshVisibility() {
        this.selectorBlock.visible(this.application == null);
        this.applicationBlock.visible(this.application != null);
    }

    private void refreshSelector() {
        int countApplications = ((MatisseBox)this.box()).applications().size();
        this.noApplications.visible(countApplications <= 0);
        this.applicationSelectorBlock.visible(countApplications > 0);
        if (this.application == null) {
            return;
        }
        this.applicationMenu.select(new String[]{this.application.label()});
    }

    private void refreshApplication() {
        if (this.application == null) {
            return;
        }
        this.processListStamp.application(this.application);
        this.processListStamp.onOpenApplication(this::open);
        this.processListStamp.refresh();
    }

    private void open(String key) {
        if (this.isCurrent(key)) {
            return;
        }
        ((ApplicationTemplateNotifier)this.notifier).redirect(this.session().browser().baseUrl() + "/application/" + ((MatisseBox)this.box()).application(key).name());
    }

    private boolean isCurrent(String key) {
        if (this.application == null) {
            return false;
        }
        return this.application.name().equals(key) || this.application.label().equals(key);
    }
}

