/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.bpm.BpmViewer;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.ui.datasources.ProcessDatasources;
import io.intino.matisse.box.ui.displays.DisplayHelper;
import io.intino.matisse.box.ui.displays.items.ActiveProcessViewItem;
import io.intino.matisse.box.ui.displays.templates.AbstractActiveProcessCatalog;
import io.intino.matisse.box.ui.displays.templates.ProcessItemDataView;
import java.time.Instant;

public class ActiveProcessCatalog
extends AbstractActiveProcessCatalog<MatisseBox> {
    private Application application;
    private String condition;

    public ActiveProcessCatalog(MatisseBox box) {
        super(box);
    }

    public ActiveProcessCatalog application(Application application) {
        this.application = application;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initList();
    }

    public ActiveProcessCatalog search(String condition) {
        this.condition = condition;
        this.activeProcessList.filter(condition);
        return this;
    }

    public ActiveProcessCatalog reload() {
        if (this.activeProcessList.source() == null) {
            this.activeProcessList.source(ProcessDatasources.active((MatisseBox)this.box(), this.session(), this.application));
        } else {
            this.activeProcessList.reload();
        }
        return this;
    }

    private void initList() {
        this.activeProcessList.onAddItem(event -> {
            BpmViewer.ProcessInfo process = (BpmViewer.ProcessInfo)event.item();
            ActiveProcessViewItem view = (ActiveProcessViewItem)event.component();
            view.title.address(path -> path.replace(":name", this.application.name()).replace(":timetag", Timetag.of((Instant)Instant.now(), (Scale)Scale.Month).toString()).replace(":process", process.id()));
            view.title.title(DisplayHelper.label(process));
            view.subtitle.value(DisplayHelper.type(process));
            this.refreshExtraData(process, view);
        });
    }

    private void refreshExtraData(BpmViewer.ProcessInfo process, ActiveProcessViewItem view) {
        view.extraData.clear();
        this.fill(this.translate("Start date"), DisplayHelper.startDate(process), (ProcessItemDataView)view.extraData.add());
        this.fill(this.translate("Finish date"), DisplayHelper.endDate(process), (ProcessItemDataView)view.extraData.add());
        if (!DisplayHelper.label(process).equals(process.id())) {
            this.fill("id", process.id(), (ProcessItemDataView)view.extraData.add());
        }
    }

    private void fill(String name, String value, ProcessItemDataView view) {
        view.name.value(name);
        view.value.value(value);
    }
}

