/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box.ui.displays;

import io.intino.alexandria.bpm.BpmViewer;
import io.intino.matisse.Application;
import io.intino.matisse.box.MatisseBox;
import io.intino.matisse.box.schemas.Graph;
import io.intino.matisse.box.schemas.GraphLink;
import io.intino.matisse.box.schemas.GraphNode;
import io.intino.matisse.box.ui.datasources.ProcessMessage;
import io.intino.matisse.box.ui.displays.AbstractGraphDisplay;
import io.intino.matisse.box.ui.displays.notifiers.GraphDisplayNotifier;
import io.intino.matisse.util.ProcessHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GraphDisplay
extends AbstractGraphDisplay<MatisseBox> {
    private Application application;
    private BpmViewer.ProcessInfo process;

    public GraphDisplay(MatisseBox box) {
        super(box);
    }

    public GraphDisplay application(Application application) {
        this.application = application;
        return this;
    }

    public GraphDisplay process(BpmViewer.ProcessInfo process) {
        this.process = process;
        return this;
    }

    public void refresh() {
        super.refresh();
        ((GraphDisplayNotifier)this.notifier).refresh(this.graph());
    }

    private Graph graph() {
        if (this.process.definition() == null) {
            return null;
        }
        return new Graph().nodes(this.nodes()).links(this.links()).start(this.start());
    }

    private String start() {
        return this.process.definition().states().stream().filter(s -> s.types().contains("Initial")).map(BpmViewer.Definition.State::name).findFirst().orElse(null);
    }

    private List<GraphNode> nodes() {
        Map<String, Integer> depthMap = this.calculateDepth();
        long max = depthMap.values().stream().mapToLong(v -> v.intValue()).max().orElse(0L);
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        String pending = this.pendingProcess();
        int i = 1;
        while ((long)i <= max) {
            List<BpmViewer.Definition.State> depthStates = this.states(depthMap, i);
            int x = depthStates.size() == 1 ? 120 : 20;
            int y = 20 + (i - 1) * 100;
            for (int j = 0; j < depthStates.size(); ++j) {
                result.add(this.graphNodeOf(depthStates.get(j), x, y, pending));
                x = (int)((long)x + Math.round(400.0 / (double)depthStates.size()));
            }
            ++i;
        }
        return result;
    }

    private List<BpmViewer.Definition.State> states(Map<String, Integer> depthMap, int i) {
        return depthMap.entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(i)).map(e -> this.state((String)e.getKey())).collect(Collectors.toList());
    }

    private BpmViewer.Definition.State state(String name) {
        return this.process.definition().states().stream().filter(s -> s.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private Map<String, Integer> calculateDepth() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List links = this.process.definition().links();
        int depth = 0;
        for (BpmViewer.Definition.Link link : links) {
            if (result.containsKey(link.from())) continue;
            result.put(link.from(), ++depth);
        }
        for (BpmViewer.Definition.Link link : links) {
            if (result.containsKey(link.to())) continue;
            result.put(link.to(), (Integer)result.get(link.from()) + 1);
        }
        return result;
    }

    private GraphNode graphNodeOf(BpmViewer.Definition.State state, int x, int y, String pending) {
        return new GraphNode().id(this.labelOf(state.name(), state.taskType())).color(this.colorOf(state, pending)).symbolType(this.symbolTypeOf(state)).x(x).y(y);
    }

    private String colorOf(BpmViewer.Definition.State state, String pending) {
        if (!this.process.isFinished() && pending != null && pending.equals(state.name())) {
            return "blue";
        }
        if (state.types().contains("Initial")) {
            return "lightgreen";
        }
        if (state.types().contains("Terminal")) {
            return "black";
        }
        return "#d3d3d3";
    }

    private String pendingProcess() {
        List<ProcessMessage> messages = ProcessHelper.messagesOf(this.process);
        return messages.size() > 0 ? messages.get(messages.size() - 1).name() : null;
    }

    private GraphNode.SymbolType symbolTypeOf(BpmViewer.Definition.State state) {
        if (state.types().contains("Initial")) {
            return GraphNode.SymbolType.square;
        }
        if (this.process.definition().links().stream().filter(l -> l.from().equalsIgnoreCase(state.name())).count() > 1L) {
            return GraphNode.SymbolType.triangle;
        }
        return GraphNode.SymbolType.circle;
    }

    private List<GraphLink> links() {
        Map<String, String> nameInfo = this.process.definition().states().stream().collect(Collectors.toMap(BpmViewer.Definition.State::name, BpmViewer.Definition.State::taskType));
        return this.process.definition().links().stream().map(l -> this.graphLink(this.labelOf(l.from(), (String)nameInfo.get(l.from())), this.labelOf(l.to(), (String)nameInfo.get(l.to())), l.type())).collect(Collectors.toList());
    }

    private String labelOf(String name, String taskType) {
        return name + (String)(taskType.equalsIgnoreCase("Default") ? "" : " (" + this.translate(taskType) + ")");
    }

    private GraphNode graphNode(String id, String type, int x, int y, String color, GraphNode.SymbolType symbol) {
        return new GraphNode().id(id).x(x).y(y).color(color).symbolType(symbol);
    }

    private GraphLink graphLink(String source, String target, String label) {
        return new GraphLink().source(source).target(target).label(this.translate(!label.equalsIgnoreCase("default") ? label : "")).renderLabel(true);
    }

    public String translate(String word) {
        return ((MatisseBox)this.box()).translatorService().translate(word, this.language());
    }

    public String language() {
        return this.session() != null ? this.session().discoverLanguage() : "en";
    }
}

