/*
 * Decompiled with CFR 0.152.
 */
package io.intino.matisse.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.amidas.shared.Team;
import io.intino.matisse.ActionDispatcher;
import io.intino.matisse.Application;
import io.intino.matisse.box.AbstractBox;
import io.intino.matisse.box.MatisseConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class MatisseBox
extends AbstractBox {
    private List<Application> applications = new ArrayList<Application>();
    private String title = "Process viewer";
    private URL logo = MatisseBox.class.getResource("/images/logo.png");
    private URL background = null;
    private Team team;
    private ActionDispatcher actionDispatcher;

    public MatisseBox(String[] args) {
        super(args);
    }

    public MatisseBox(MatisseConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    public List<Application> applications() {
        return new ArrayList<Application>(this.applications);
    }

    public Application application(String key) {
        return this.applications.stream().filter(a -> a.name().equals(key) || a.label().equals(key)).findFirst().orElse(null);
    }

    public MatisseBox add(Application application) {
        this.applications.add(application);
        return this;
    }

    public String title() {
        return this.title;
    }

    public URL logo() {
        return this.logo;
    }

    public URL background() {
        return this.background;
    }

    public MatisseBox properties(String title, URL logo, URL background) {
        this.title = title;
        this.logo = logo;
        this.background = background;
        return this;
    }

    public ActionDispatcher actionDispatcher() {
        return this.actionDispatcher;
    }

    public MatisseBox actionDispatcher(ActionDispatcher actionDispatcher) {
        this.actionDispatcher = actionDispatcher;
        return this;
    }

    @Override
    public void beforeStart() {
        this.team = this.createTeam();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    public Team team() {
        return this.team;
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        try {
            if (authServiceUrl == null) {
                return null;
            }
            return new AmidasOauthAccessor(new Space(new URL(this.configuration().url())), authServiceUrl);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void reloadTeam() {
        this.team = this.createTeam();
    }

    private Team createTeam() {
        try {
            File file = new File(this.configuration().identitiesFile());
            return file.exists() ? new Team(file) : null;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

