/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.async;

import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.generators.FileBodyGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.sonatype.aether.connector.async.CompletionHandler;
import org.sonatype.aether.transfer.TransferCancelledException;

class ProgressingFileBodyGenerator
extends FileBodyGenerator {
    private final CompletionHandler completionHandler;

    public ProgressingFileBodyGenerator(File file, CompletionHandler completionHandler) {
        super(file);
        this.completionHandler = completionHandler;
    }

    public RandomAccessBody createBody() throws IOException {
        return new ProgressingBody(super.createBody());
    }

    final class ProgressingWritableByteChannel
    implements WritableByteChannel {
        final WritableByteChannel delegate;

        public ProgressingWritableByteChannel(WritableByteChannel delegate) {
            this.delegate = delegate;
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int write(ByteBuffer src) throws IOException {
            ByteBuffer event = src.slice();
            int written = this.delegate.write(src);
            if (written > 0) {
                try {
                    event.limit(written);
                    ProgressingFileBodyGenerator.this.completionHandler.fireTransferProgressed(event);
                }
                catch (TransferCancelledException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            return written;
        }
    }

    final class ProgressingBody
    implements RandomAccessBody {
        final RandomAccessBody delegate;
        private ProgressingWritableByteChannel channel;

        public ProgressingBody(RandomAccessBody delegate) {
            this.delegate = delegate;
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }

        public long read(ByteBuffer buffer) throws IOException {
            ByteBuffer event = buffer.slice();
            long read = this.delegate.read(buffer);
            if (read > 0L) {
                try {
                    event.limit((int)read);
                    ProgressingFileBodyGenerator.this.completionHandler.fireTransferProgressed(event);
                }
                catch (TransferCancelledException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            return read;
        }

        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            ProgressingWritableByteChannel dst = this.channel;
            if (dst == null || dst.delegate != target) {
                this.channel = dst = new ProgressingWritableByteChannel(target);
            }
            return this.delegate.transferTo(position, Math.min(count, 16384L), dst);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

