/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.model.marks;

import org.siani.itrules.model.Literal;
import org.siani.itrules.model.Token;
import org.siani.itrules.model.marks.AbstractMark;

public class Mark
extends AbstractMark {
    private static final String NewLine = "\n";
    private static final String OptionSeparator = "+";
    private String name;
    private String[] options;
    private String separator = null;

    public Mark(String name, String ... options) {
        this.name = name;
        this.options = options;
    }

    public Mark multiple(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public String fullName() {
        return this.name + this.optionsText();
    }

    private String optionsText() {
        String result = "";
        for (String option : this.options) {
            result = result + OptionSeparator + option;
        }
        return result;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public boolean isMultiple() {
        return this.separator != null;
    }

    @Override
    public String[] options() {
        return this.options;
    }

    @Override
    public String indentation() {
        return this.indentOf(this.previous);
    }

    private String indentOf(Token token) {
        return token == null ? "" : (this.textOf(token).isEmpty() ? this.indentOf(token.previous()) : this.textOf(token));
    }

    private String textOf(Token token) {
        return token instanceof Literal ? this.extractIndent(((Literal)token).text()) : "";
    }

    private String extractIndent(String text) {
        String[] split = text.substring((NewLine + text).lastIndexOf(NewLine)).split("[^\\s]");
        return split.length == 0 ? "" : split[0];
    }

    @Override
    public String toString() {
        return "[" + this.name + (this.isMultiple() ? "..." : "") + "]";
    }
}

