/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.siani.itrules.engine.SlotSet;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.PrimitiveFrame;

public class Frame
implements AbstractFrame {
    private final Set<String> types = Frame.createTypeSet();
    private final SlotSet slots = SlotSet.create();

    public Frame(String ... types) {
        this.addTypes(types);
    }

    private static Set<String> createTypeSet() {
        return new HashSet<String>(){

            @Override
            public boolean contains(Object o) {
                return super.contains(o.toString().toLowerCase());
            }

            @Override
            public boolean add(String s) {
                return super.add(s.toLowerCase());
            }
        };
    }

    @Override
    public boolean is(String type) {
        return this.types.contains(type);
    }

    public String[] types() {
        return this.types.toArray(new String[this.types.size()]);
    }

    public String[] slots() {
        return this.slots.names();
    }

    @Override
    public Iterator<AbstractFrame> frames(String slot) {
        return this.slots.get(slot) != null ? this.slots.get(slot).iterator() : Collections.emptyList().iterator();
    }

    public Frame addTypes(List<String> types) {
        return this.addTypes(types.toArray(new String[types.size()]));
    }

    public Frame addTypes(String ... types) {
        Collections.addAll(this.types, types);
        return this;
    }

    public Frame addSlots(SlotSet slots) {
        this.slots.add(slots);
        return this;
    }

    public Frame addSlot(String slot, AbstractFrame ... frames) {
        for (AbstractFrame frame : frames) {
            this.slots.get(slot).add(frame);
        }
        return this;
    }

    public Frame addSlot(String slot, Object ... values) {
        for (Object value : values) {
            this.createSlot(slot, value.toString());
        }
        return this;
    }

    public Frame addSlot(String slot, String ... values) {
        for (String value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    public Frame addSlot(String slot, Integer ... values) {
        for (Integer value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    public Frame addSlot(String slot, Boolean ... values) {
        for (Boolean value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    public Frame addSlot(String slot, Long ... values) {
        for (Long value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    public Frame addSlot(String slot, Double ... values) {
        for (Double value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    public Frame addSlot(String slot, Date ... values) {
        for (Date value : values) {
            this.createSlot(slot, value);
        }
        return this;
    }

    private void createSlot(String slot, Object value) {
        this.slots.get(slot).add(new PrimitiveFrame(value));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Object value() {
        return null;
    }

    public String toString() {
        return this.types.toString().replace(", object", "");
    }
}

