/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.functions;

import java.util.Iterator;
import org.siani.itrules.Function;
import org.siani.itrules.engine.FunctionEvaluator;
import org.siani.itrules.engine.Trigger;
import org.siani.itrules.model.AbstractFrame;

public final class AttributeFunction
implements Function {
    @Override
    public boolean match(Trigger trigger, String parameter) {
        return new FunctionEvaluator(parameter).evaluate(v -> this.matchSlot(trigger, (String)v));
    }

    private boolean matchSlot(Trigger trigger, String condition) {
        return this.matchSlot(trigger.frame(), condition);
    }

    private boolean matchSlot(AbstractFrame frame, String condition) {
        return condition.contains(":") ? this.matchSlot(frame, condition.split(":")) : (frame.isPrimitive() ? this.hasValue(frame, condition) : this.hasSlot(frame, condition));
    }

    private boolean matchSlot(AbstractFrame frame, String[] condition) {
        return this.hasSlotValue(frame, condition[0], condition[1]);
    }

    private boolean hasSlot(AbstractFrame frame, String slot) {
        return frame.frames(slot).hasNext();
    }

    private boolean hasValue(AbstractFrame frame, String value) {
        return value.contains(frame.value().toString().replaceAll("\\s", ""));
    }

    private boolean hasSlotValue(AbstractFrame frame, String slot, String value) {
        return this.checkAny(frame.frames(slot), value);
    }

    private boolean checkAny(Iterator<AbstractFrame> frames, String value) {
        while (frames.hasNext()) {
            AbstractFrame frame = frames.next();
            if (!frame.isPrimitive() || !value.equalsIgnoreCase(frame.value().toString())) continue;
            return true;
        }
        return false;
    }
}

