/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters.inflectors;

import java.util.HashMap;
import java.util.Map;

public abstract class PluralInflector {
    private Map<String, String> irregulars = new HashMap<String, String>();
    private Map<String, String> replaces = new HashMap<String, String>();

    public PluralInflector() {
        this.setIrregulars();
        this.setReplaces();
    }

    public abstract String plural(String var1);

    protected abstract void setReplaces();

    protected abstract void setIrregulars();

    protected void addReplace(String from, String to) {
        this.replaces.put(from, to);
    }

    protected void addIrregular(String from, String to) {
        this.irregulars.put(from, to);
    }

    protected String doReplaces(String word) {
        for (String ending : this.replaces.keySet()) {
            if (!word.endsWith(ending)) continue;
            return this.replaceLast(word, ending);
        }
        return word;
    }

    protected char[] consonants() {
        return "bcdfghjklmnpqrstvwxyz".toCharArray();
    }

    protected boolean isIrregular(String word) {
        return this.irregulars.containsKey(word);
    }

    protected String irregularPlural(String word) {
        return this.irregulars.get(word);
    }

    private String replaceLast(String word, String ending) {
        return this.removeEnding(word, ending) + this.replaces.get(ending);
    }

    private String removeEnding(String word, String ending) {
        return word.substring(0, word.length() - ending.length());
    }
}

