/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters;

import java.util.HashMap;
import java.util.Map;
import org.siani.itrules.Formatter;

public final class StringFormatter {
    private static Map<String, Formatter> map = null;

    public static Map<String, Formatter> get() {
        if (map == null) {
            StringFormatter.createFormatters();
        }
        return map;
    }

    private static void createFormatters() {
        map = new HashMap<String, Formatter>();
        StringFormatter.add("UpperCase", StringFormatter.upperCase());
        StringFormatter.add("LowerCase", StringFormatter.lowerCase());
        StringFormatter.add("FirstUpperCase", StringFormatter.firstUpperCase());
        StringFormatter.add("FirstLowerCase", StringFormatter.firstLowerCase());
        StringFormatter.add("Camelcase", StringFormatter.camelCase());
        StringFormatter.add("LowerCamelCase", StringFormatter.lowerCamelCase());
        StringFormatter.add("SnakeCase", StringFormatter.snakeCase());
        StringFormatter.add("Capitalize", StringFormatter.capitalize());
        StringFormatter.add("Length", StringFormatter.length());
    }

    private static void add(String name, Formatter formatter) {
        map.put(name.toLowerCase(), formatter);
    }

    public static Formatter upperCase() {
        return value -> value.toString().toUpperCase();
    }

    public static Formatter lowerCase() {
        return value -> value.toString().toLowerCase();
    }

    public static Formatter camelCase() {
        return value -> {
            String[] parts = value.toString().split(" ");
            String result = "";
            for (String part : parts) {
                result = result + StringFormatter.capitalize().format(part);
            }
            return result;
        };
    }

    public static Formatter lowerCamelCase() {
        return value -> {
            String[] parts = value.toString().split(" ");
            String result = "";
            for (String part : parts) {
                result = result + StringFormatter.capitalize().format(part);
            }
            return result.substring(0, 1).toLowerCase() + result.substring(1);
        };
    }

    public static Formatter snakeCase() {
        return value -> value.toString().toLowerCase().replaceAll(" ", "-");
    }

    public static Formatter firstUpperCase() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toUpperCase() + value.toString().substring(1);
    }

    public static Formatter firstLowerCase() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toLowerCase() + value.toString().substring(1);
    }

    public static Formatter capitalize() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toUpperCase() + value.toString().substring(1).toLowerCase();
    }

    public static Formatter length() {
        return value -> String.valueOf(value.toString().length());
    }
}

