/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.siani.itrules.Formatter;
import org.siani.itrules.engine.formatters.inflectors.EnglishPluralInflector;
import org.siani.itrules.engine.formatters.inflectors.PluralInflector;
import org.siani.itrules.engine.formatters.inflectors.SpanishPluralInflector;

public class PluralFormatter
implements Formatter {
    private static Map<String, PluralInflector> inflectors = new HashMap<String, PluralInflector>();
    private Locale locale;

    public PluralFormatter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Object format(Object value) {
        return this.getInflector().plural(value.toString());
    }

    public PluralInflector getInflector() {
        return this.getInflector(this.locale.getLanguage());
    }

    private PluralInflector getInflector(String key) {
        return inflectors.containsKey(key) ? inflectors.get(key) : inflectors.get("en");
    }

    static {
        inflectors.put("en", new EnglishPluralInflector());
        inflectors.put("es", new SpanishPluralInflector());
    }
}

