/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.siani.itrules.Formatter;
import org.siani.itrules.engine.formatters.spelling.EnglishSpelling;
import org.siani.itrules.engine.formatters.spelling.SpanishSpelling;
import org.siani.itrules.engine.formatters.spelling.WordSpelling;

public class NumberSpellingFormatter
implements Formatter {
    private static Map<String, WordSpelling> readers = new HashMap<String, WordSpelling>();
    private Locale locale;

    public NumberSpellingFormatter(Locale locale) {
        this.locale = locale;
    }

    private static boolean isNumber(Object value) {
        return Number.class.isAssignableFrom(value.getClass());
    }

    @Override
    public Object format(Object value) {
        return NumberSpellingFormatter.isNumber(value) ? this.getReader().spell((Integer)value) : value;
    }

    public WordSpelling getReader() {
        return this.getReader(this.locale.getLanguage());
    }

    private WordSpelling getReader(String key) {
        return readers.containsKey(key) ? readers.get(key) : readers.get("en");
    }

    static {
        readers.put("en", new EnglishSpelling());
        readers.put("es", new SpanishSpelling());
    }
}

