/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.siani.itrules.Formatter;
import org.siani.itrules.engine.formatters.NumberSpellingFormatter;

public class NumberFormatter {
    public static Map<String, Formatter> get(Locale locale) {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        map.put("Words".toLowerCase(), new NumberSpellingFormatter(locale));
        map.put("Separators".toLowerCase(), NumberFormatter.separators(locale));
        map.put("TwoDecimals".toLowerCase(), NumberFormatter.twoDecimals(locale));
        return map;
    }

    public static Formatter separators(Locale locale) {
        return value -> {
            if (!NumberFormatter.isNumber(value)) {
                return value;
            }
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            df.setGroupingUsed(true);
            df.setGroupingSize(3);
            return df.format(value);
        };
    }

    public static Formatter twoDecimals(Locale locale) {
        return value -> {
            if (!NumberFormatter.isNumber(value)) {
                return value;
            }
            double n = ((Number)value).doubleValue();
            return String.format(locale, "%.2f", n);
        };
    }

    private static boolean isNumber(Object value) {
        return Number.class.isAssignableFrom(value.getClass());
    }
}

