/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine.formatters;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.siani.itrules.Formatter;

public class DateFormatter {
    public static Map<String, Formatter> get(Locale locale) {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        map.put("Year".toLowerCase(), DateFormatter.year());
        map.put("MonthYear".toLowerCase(), DateFormatter.monthYear(locale));
        map.put("ShortDate".toLowerCase(), DateFormatter.shortDate(locale));
        map.put("FullDate".toLowerCase(), DateFormatter.fullDate(locale));
        map.put("DayOfWeek".toLowerCase(), DateFormatter.dayOfWeek(locale));
        map.put("Time".toLowerCase(), DateFormatter.time(locale));
        return map;
    }

    public static Formatter year() {
        return value -> value instanceof Date ? Integer.valueOf(((Date)value).getYear() + 1900) : value;
    }

    public static Formatter monthYear(Locale locale) {
        return value -> DateFormatter.formatDate(value, "MMMM yyyy", locale);
    }

    public static Formatter shortDate(Locale locale) {
        return value -> DateFormatter.formatDate(value, "dd/MM/yyyy", locale);
    }

    public static Formatter fullDate(Locale locale) {
        return value -> DateFormatter.formatDate(value, "dd MMMM yyyy", locale);
    }

    public static Formatter dayOfWeek(Locale locale) {
        return value -> DateFormatter.formatDate(value, "EEEE", locale);
    }

    public static Formatter time(Locale locale) {
        return value -> DateFormatter.formatDate(value, "HH:mm", locale);
    }

    private static Object formatDate(Object value, String format, Locale locale) {
        return value instanceof Date ? new SimpleDateFormat(format, locale).format((Date)value) : value;
    }
}

