/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine;

import java.util.HashMap;
import java.util.Map;
import org.siani.itrules.Function;
import org.siani.itrules.engine.functions.AttributeFunction;
import org.siani.itrules.engine.functions.TriggerFunction;
import org.siani.itrules.engine.functions.TypeFunction;
import org.siani.itrules.model.Condition;

public final class FunctionIndex {
    private Map<String, Function> map = new HashMap<String, Function>();

    public FunctionIndex() {
        this.add("Type", new TypeFunction());
        this.add("Trigger", new TriggerFunction());
        this.add("Attribute", new AttributeFunction());
        this.add("Primitive", this.primitiveFunction());
    }

    public Function get(Condition condition) {
        return this.exists(condition.name()) ? this.createFunction(condition) : this.unknownFunction(condition);
    }

    private Function createFunction(Condition condition) {
        Function function = this.map.get(condition.name().toLowerCase());
        return condition.negated() ? this.negatedFunction(function) : function;
    }

    private boolean exists(String function) {
        return this.map.containsKey(function.toLowerCase());
    }

    private Function negatedFunction(Function function) {
        return (trigger, parameter) -> !function.match(trigger, parameter);
    }

    private Function unknownFunction(Condition condition) {
        throw new RuntimeException("Function " + condition.name() + " doesn't exists");
    }

    private Function primitiveFunction() {
        return (trigger, parameter) -> trigger.frame().isPrimitive();
    }

    public void add(String name, Function function) {
        this.map.put(name.toLowerCase(), function);
    }
}

