/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.Context;
import org.siani.itrules.engine.DefaultAdapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import org.siani.itrules.model.PrimitiveFrame;

public final class FrameBuilder {
    private final Map<Class, Adapter> registers;
    private Frame frame;

    public FrameBuilder() {
        this(new HashMap<Class, Adapter>());
    }

    private FrameBuilder(Map<Class, Adapter> registers) {
        this.registers = registers;
    }

    public AbstractFrame build(Object object) {
        return this.isPrimitive(object) ? this.primitiveFrameOf(object) : (this.isCollection(object) ? this.frameOf(new Collection(object)) : this.frameOf(object));
    }

    public <T> void register(Class<T> aClass, Adapter<T> adapter) {
        this.registers.put(aClass, adapter);
    }

    private PrimitiveFrame primitiveFrameOf(Object object) {
        return new PrimitiveFrame(object);
    }

    private Frame frameOf(Object object) {
        if (object instanceof Frame) {
            return (Frame)object;
        }
        this.frame = new Frame(new String[0]);
        this.frame.addTypes(this.typesOf(object));
        this.adapterFor(object).adapt(object, this.context());
        return this.frame;
    }

    private Adapter adapterFor(Object object) {
        List adapters = this.classesOf(object).stream().map(this::adapterFor).collect(Collectors.toList());
        for (Adapter adapter : adapters) {
            if (adapter == null) continue;
            return adapter;
        }
        return new DefaultAdapter();
    }

    private Adapter adapterFor(Class aClass) {
        return this.registers.getOrDefault(aClass, null);
    }

    private List<String> typesOf(Object object) {
        return this.classesOf(object).stream().map(Class::getSimpleName).collect(Collectors.toList());
    }

    private List<Class> classesOf(Object object) {
        return this.classesOf(object.getClass());
    }

    private Context context() {
        return new Context(){

            @Override
            public Frame frame() {
                return FrameBuilder.this.frame;
            }

            @Override
            public AbstractFrame build(Object object) {
                return new FrameBuilder(FrameBuilder.this.registers).build(object);
            }

            @Override
            public <S> void register(Class<S> aClass, Adapter<S> adapter) {
                FrameBuilder.this.register(aClass, adapter);
            }
        };
    }

    private List<Class> classesOf(Class aClass) {
        ArrayList<Class> types = new ArrayList<Class>();
        if (aClass == null) {
            return types;
        }
        if (!aClass.getSimpleName().isEmpty()) {
            types.add(aClass);
        }
        types.addAll(this.classesOf(aClass.getSuperclass()));
        types.addAll(this.interfacesOf(aClass));
        return types;
    }

    private List<Class> interfacesOf(Class aClass) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        for (Class<?> aInterface : aClass.getInterfaces()) {
            interfaces.addAll(this.classesOf(aInterface));
        }
        return interfaces;
    }

    private boolean isPrimitive(Object object) {
        return this.isPrimitive(object.getClass());
    }

    private boolean isPrimitive(Class aClass) {
        return aClass.isPrimitive() || String.class.isAssignableFrom(aClass) || Byte.class.isAssignableFrom(aClass) || Short.class.isAssignableFrom(aClass) || Integer.class.isAssignableFrom(aClass) || Long.class.isAssignableFrom(aClass) || Float.class.isAssignableFrom(aClass) || Double.class.isAssignableFrom(aClass) || Boolean.class.isAssignableFrom(aClass) || Date.class.isAssignableFrom(aClass) || Enum.class.isAssignableFrom(aClass) || Character.class.isAssignableFrom(aClass);
    }

    private boolean isCollection(Object object) {
        return this.isCollection(object.getClass());
    }

    private boolean isCollection(Class<?> aClass) {
        return Map.class.isAssignableFrom(aClass) || List.class.isAssignableFrom(aClass) || aClass.isArray();
    }

    private class Collection {
        final Object items;

        private Collection(Object items) {
            this.items = items;
        }
    }
}

