/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.siani.itrules.Formatter;
import org.siani.itrules.engine.formatters.DateFormatter;
import org.siani.itrules.engine.formatters.NumberFormatter;
import org.siani.itrules.engine.formatters.PluralFormatter;
import org.siani.itrules.engine.formatters.StringFormatter;

public class FormatterIndex {
    private Map<String, Formatter> map = new HashMap<String, Formatter>();

    public FormatterIndex(Locale locale) {
        this.map.putAll(StringFormatter.get());
        this.map.putAll(DateFormatter.get(locale));
        this.map.putAll(NumberFormatter.get(locale));
        this.map.put("plural", new PluralFormatter(locale));
    }

    public void add(String name, Formatter formatter) {
        this.map.put(name.toLowerCase(), formatter);
    }

    public Formatter get(String name) {
        return !name.isEmpty() ? this.formatter(name) : this.nullFormatter();
    }

    public boolean exists(String name) {
        return this.map.containsKey(name.trim().toLowerCase());
    }

    private Formatter formatter(String name) {
        return this.exists(name) ? this.map.get(name.toLowerCase()) : this.unknownFormatter();
    }

    private Formatter unknownFormatter() {
        return new Formatter(){

            @Override
            public Object format(Object value) {
                return value;
            }
        };
    }

    private Formatter nullFormatter() {
        return new Formatter(){

            @Override
            public Object format(Object value) {
                return value;
            }
        };
    }
}

