/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.Context;
import org.siani.itrules.engine.SlotSet;
import org.siani.itrules.model.PrimitiveFrame;

public class DefaultAdapter<T>
implements Adapter<T> {
    protected boolean isProcessable(Field field) {
        return !this.isExcluded(field);
    }

    private boolean isExcluded(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || this.isContextFieldOfInnerClass(field);
    }

    private boolean isContextFieldOfInnerClass(Field field) {
        return field.getName().startsWith("this$");
    }

    @Override
    public void adapt(T source, Context context) {
        context.frame().addSlots(new SlotBuilder(source, context).slots());
    }

    private class SlotBuilder {
        private final Object source;
        private Context context;
        private SlotSet slots = SlotSet.create();
        private static final String Count = "Count";

        public SlotBuilder(Object source, Context context) {
            this.source = source;
            this.context = context;
        }

        public SlotSet slots() {
            try {
                this.execute(this.source.getClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return this.slots;
        }

        private void execute(Class aClass) throws IllegalAccessException {
            while (aClass != null) {
                this.processClass(aClass);
                aClass = aClass.getSuperclass();
            }
        }

        private void processClass(Class aClass) throws IllegalAccessException {
            for (Field field : aClass.getDeclaredFields()) {
                if (!DefaultAdapter.this.isProcessable(field)) continue;
                this.processField(field);
            }
        }

        private void processField(Field field) throws IllegalAccessException {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            if (field.get(this.source) != null) {
                this.processField(field.getName(), field.get(this.source));
            }
            field.setAccessible(accessibility);
        }

        private void processField(String name, Object value) throws IllegalAccessException {
            if (this.isArray(value.getClass())) {
                this.processArray(name, value);
            } else if (this.isList(value.getClass())) {
                this.processList(name, value);
            } else if (this.isMap(value.getClass())) {
                this.processMap(name, value);
            } else {
                this.slots.add(name, this.context.build(value));
            }
        }

        private void processArray(String name, Object value) throws IllegalAccessException {
            Object[] objects = (Object[])value;
            this.slots.add(name + Count, new PrimitiveFrame(objects.length));
            for (Object item : objects) {
                this.slots.add(name, this.context.build(item));
            }
        }

        private void processList(String name, Object value) throws IllegalAccessException {
            List list = (List)value;
            this.slots.add(name + Count, new PrimitiveFrame(list.size()));
            for (Object item : list) {
                this.slots.add(name, this.context.build(item));
            }
        }

        private void processMap(String name, Object value) throws IllegalAccessException {
            Map map = (Map)value;
            this.slots.add(name + Count, new PrimitiveFrame(map.keySet().size()));
            for (Object key : map.keySet()) {
                this.slots.add(name, this.context.build(new Item(key, map.get(key))));
            }
        }

        private boolean isMap(Class<?> aClass) {
            return Map.class.isAssignableFrom(aClass);
        }

        private boolean isList(Class<?> aClass) {
            return List.class.isAssignableFrom(aClass);
        }

        private boolean isArray(Class<?> aClass) {
            return aClass.isArray();
        }
    }

    private static class Item {
        public Object key;
        public Object value;

        public Item(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

