/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules.engine;

public class Buffer {
    private static final char NEW_LINE = '\n';
    private boolean replaced = false;
    private StringBuilder content = new StringBuilder("");
    private String indentation;

    public Buffer(String indentation) {
        this.indentation = indentation;
    }

    public boolean isUsed() {
        return this.replaced;
    }

    public void used() {
        this.replaced = true;
    }

    public void write(Buffer buffer) {
        this.write(buffer.content.toString());
    }

    public void write(String text) {
        this.content.append(this.indent(text));
    }

    private String indent(String text) {
        return this.indent((text + "~").toCharArray());
    }

    private String indent(char[] data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length - 1; ++i) {
            result.append(data[i]).append(data[i] == '\n' && data[i + 1] != '\n' ? this.indentation : "");
        }
        return result.toString();
    }

    public String toString() {
        return this.content.toString();
    }

    public String indentation() {
        return this.indentation;
    }
}

