/*
 * Decompiled with CFR 0.152.
 */
package org.siani.itrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.Formatter;
import org.siani.itrules.Function;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Source;
import org.siani.itrules.engine.Buffer;
import org.siani.itrules.engine.FormatterIndex;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.engine.FunctionIndex;
import org.siani.itrules.engine.RuleSet;
import org.siani.itrules.engine.RuleSetLoader;
import org.siani.itrules.engine.Trigger;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Expression;
import org.siani.itrules.model.PrimitiveFrame;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;
import org.siani.itrules.model.marks.AbstractMark;
import org.siani.itrules.model.marks.DelegateMark;
import org.siani.itrules.model.marks.Mark;

public class TemplateEngine {
    public static final String CutLine = "|>";
    private final LineSeparator lineSeparator;
    private final RuleSet ruleSet = new RuleSet();
    private final Stack<Buffer> buffers = new Stack();
    private final FormatterIndex formatterIndex;
    private final FunctionIndex functionIndex;
    private final FrameBuilder frameBuilder;

    public TemplateEngine() {
        this(Locale.getDefault());
    }

    public TemplateEngine(Locale locale) {
        this(locale, LineSeparator.LF);
    }

    public TemplateEngine(Locale locale, LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.ruleSet.add(this.defaultRule());
        this.formatterIndex = new FormatterIndex(locale);
        this.functionIndex = new FunctionIndex();
        this.frameBuilder = new FrameBuilder();
    }

    private TemplateEngine(TemplateEngine engine) {
        this.lineSeparator = engine.lineSeparator;
        this.ruleSet.add(this.defaultRule());
        this.formatterIndex = engine.formatterIndex;
        this.functionIndex = engine.functionIndex;
        this.frameBuilder = engine.frameBuilder;
    }

    public static TemplateEngine with(String template) {
        return new TemplateEngine().use(template);
    }

    public TemplateEngine use(String pathname) {
        return this.use(new Source(pathname));
    }

    public TemplateEngine use(Source source) {
        this.ruleSet.add(RuleSetLoader.load(source));
        return this;
    }

    TemplateEngine add(Rule ... rules) {
        return this.add(Arrays.asList(rules));
    }

    TemplateEngine add(List<Rule> rules) {
        this.ruleSet.add(rules);
        return this;
    }

    RuleSet ruleSet() {
        return this.ruleSet;
    }

    public TemplateEngine add(String format, Formatter formatter) {
        this.formatterIndex.add(format, formatter);
        return this;
    }

    public TemplateEngine add(String format, TemplateEngine engine) {
        this.add(format, engine::render);
        return this;
    }

    public TemplateEngine add(String format, String pathname) {
        this.add(format, new TemplateEngine(this).use(pathname));
        return this;
    }

    public TemplateEngine add(String format, Source source) {
        this.add(format, new TemplateEngine(this).use(source));
        return this;
    }

    public TemplateEngine add(String name, Function function) {
        this.functionIndex.add(name, function);
        return this;
    }

    public <T> TemplateEngine add(Class<T> class_, Adapter<T> adapter) {
        this.frameBuilder.register(class_, adapter);
        return this;
    }

    public String render(Object object) {
        return this.render(this.frameBuilder.build(object));
    }

    private Rule defaultRule() {
        return new Rule().add(new Condition("Primitive", "")).add((Token.Body)new Mark("value", new String[0]));
    }

    private String render(AbstractFrame frame) {
        this.initBuffer();
        this.execute(new Trigger(frame, new Mark("root", new String[0])));
        return this.documentOf(this.buffer());
    }

    private String documentOf(Buffer buffer) {
        return this.encode(this.cleanEmptyLines(this.textOf(buffer)));
    }

    private String textOf(Buffer buffer) {
        return String.valueOf(buffer);
    }

    private String cleanEmptyLines(String text) {
        String EOF = "\nEOF";
        String[] lines = text.concat(EOF).split("\n");
        String result = Arrays.stream(lines).filter(this::filter).map(this::clean).collect(Collectors.joining());
        return result.substring(0, result.indexOf(EOF));
    }

    private boolean filter(String line) {
        return !line.contains(CutLine) || !line.replace(CutLine, "").matches("^\\s*$");
    }

    private String clean(String line) {
        return line.replace(CutLine, "").replaceAll("^\\s*$", "") + "\n";
    }

    private String encode(String string) {
        return this.lineSeparator == LineSeparator.CRLF ? this.toCRLF(string) : string;
    }

    private String toCRLF(String string) {
        return string.replace("\n", "\r\n");
    }

    private void initBuffer() {
        this.buffers.clear();
        this.pushBuffer("");
    }

    private boolean execute(Trigger trigger) {
        Rule rule = this.ruleFor(trigger);
        return rule != null && this.execute(trigger, rule);
    }

    private Rule ruleFor(Trigger trigger) {
        for (Rule rule : this.ruleSet) {
            if (!this.match(rule, trigger)) continue;
            return rule;
        }
        return null;
    }

    private boolean match(Rule rule, Trigger trigger) {
        for (Condition condition : rule.conditions()) {
            if (this.conditionMatchTrigger(trigger, condition)) continue;
            return false;
        }
        return true;
    }

    private boolean conditionMatchTrigger(Trigger trigger, Condition condition) {
        return this.functionIndex.get(condition).match(trigger, condition.parameter());
    }

    private Buffer buffer() {
        return this.buffers.peek();
    }

    private boolean execute(Trigger trigger, Rule rule) {
        for (Token token : rule.tokens()) {
            this.execute(trigger, token);
        }
        return true;
    }

    private boolean execute(Trigger trigger, Token token) {
        if (token instanceof AbstractMark) {
            return this.execute(trigger, token.as(AbstractMark.class));
        }
        if (token instanceof Expression) {
            return this.execute(trigger, token.as(Expression.class));
        }
        this.write(token.toString());
        return true;
    }

    private void write(String text) {
        this.buffer().write(text);
    }

    private boolean execute(Trigger trigger, AbstractMark mark) {
        return this.renderFrame(trigger.frame(), this.composeMark(trigger, mark));
    }

    private AbstractMark composeMark(Trigger trigger, AbstractMark mark) {
        return trigger.frame().isPrimitive() ? new CompositeMark(mark, trigger.mark().options()) : mark;
    }

    private boolean renderFrame(AbstractFrame frame, AbstractMark mark) {
        return frame.isPrimitive() ? this.renderPrimitiveFrame(frame, mark) : this.renderCompositeFrame(frame, mark);
    }

    private boolean renderPrimitiveFrame(AbstractFrame frame, AbstractMark mark) {
        if (!mark.name().equalsIgnoreCase("value")) {
            return false;
        }
        this.write(this.format((Object)frame, mark).toString());
        this.buffer().used();
        return true;
    }

    private boolean renderCompositeFrame(AbstractFrame frame, AbstractMark mark) {
        Iterator<AbstractFrame> frames = frame.frames(mark.name());
        return frames != null && this.renderFrames(frames, mark);
    }

    private boolean renderFrames(Iterator<AbstractFrame> frames, AbstractMark mark) {
        boolean rendered = false;
        while (frames.hasNext()) {
            this.pushBuffer(mark.indentation());
            if (rendered && mark.isMultiple()) {
                this.writeSeparator(mark);
            }
            rendered |= this.trigger(this.format((Object)frames.next(), mark), new NonFormattingMark(mark));
            this.popBuffer();
        }
        return rendered;
    }

    private boolean trigger(Object value, AbstractMark mark) {
        if (!this.execute(new Trigger(this.frame(value), mark))) {
            return false;
        }
        this.buffer().used();
        return true;
    }

    private Object format(Object value, AbstractMark mark) {
        if (value instanceof PrimitiveFrame) {
            value = ((PrimitiveFrame)value).value();
        }
        for (String option : mark.options()) {
            value = this.format(value, this.formatterIndex.get(option));
        }
        return value;
    }

    private AbstractFrame frame(Object value) {
        return value instanceof AbstractFrame ? (AbstractFrame)value : new PrimitiveFrame(value);
    }

    private Object format(Object value, Formatter formatter) {
        return formatter.format(value);
    }

    private boolean execute(Trigger trigger, Expression expression) {
        boolean result = true;
        while (expression != null) {
            this.pushBuffer("");
            if (this.isConstant(expression)) {
                this.buffer().used();
            }
            for (Token token : expression) {
                result &= this.execute(trigger, token);
            }
            expression = expression.or();
            if (!this.popBuffer()) continue;
            break;
        }
        return result;
    }

    private boolean isConstant(Expression expression) {
        for (Token token : expression) {
            if (!(token instanceof Mark)) continue;
            return false;
        }
        return true;
    }

    private void writeSeparator(AbstractMark mark) {
        this.write(mark.separator());
    }

    private void pushBuffer(String indentation) {
        this.buffers.push(new Buffer(indentation));
    }

    private boolean popBuffer() {
        Buffer pop = this.buffers.pop();
        if (pop.isUsed()) {
            this.buffer().write(pop);
            this.buffer().used();
        }
        return pop.isUsed();
    }

    private class NonFormattingMark
    extends DelegateMark {
        public NonFormattingMark(AbstractMark mark) {
            super(mark);
        }

        @Override
        public String[] options() {
            ArrayList<String> result = new ArrayList<String>();
            for (String option : this.mark.options()) {
                if (TemplateEngine.this.formatterIndex.exists(option)) continue;
                result.add(option);
            }
            return result.toArray(new String[result.size()]);
        }
    }

    private static class CompositeMark
    extends DelegateMark {
        private String[] options;

        public CompositeMark(AbstractMark mark, String[] options) {
            super(mark);
            this.options = options;
        }

        @Override
        public String[] options() {
            String[] result = new String[this.mark.options().length + this.options.length];
            System.arraycopy(this.mark.options(), 0, result, 0, this.mark.options().length);
            System.arraycopy(this.options, 0, result, this.mark.options().length, this.options.length);
            return result;
        }
    }
}

