/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyGraphBuilder.class, hint="maven31")
public class Maven31DependencyGraphBuilder
implements DependencyGraphBuilder {
    @Requirement
    private ProjectDependenciesResolver resolver;
    @Requirement
    private ArtifactFactory factory;

    @Override
    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        try {
            ProjectBuildingRequest projectBuildingRequest = (ProjectBuildingRequest)this.invoke(project.getClass(), project, "getProjectBuildingRequest");
            RepositorySystemSession session = (RepositorySystemSession)this.invoke(ProjectBuildingRequest.class, projectBuildingRequest, "getRepositorySession");
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
            request.setMavenProject(project);
            this.invoke(request, "setRepositorySession", RepositorySystemSession.class, session);
            DependencyResolutionResult result = this.resolver.resolve((DependencyResolutionRequest)request);
            org.eclipse.aether.graph.DependencyNode graph = (org.eclipse.aether.graph.DependencyNode)this.invoke(DependencyResolutionResult.class, result, "getDependencyGraph");
            return this.buildDependencyNode(null, graph, project.getArtifact(), filter);
        }
        catch (DependencyResolutionException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    private Object invoke(Class<?> clazz, Object object, String method) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return clazz.getMethod(method, new Class[0]).invoke(object, new Object[0]);
    }

    private Object invoke(Object object, String method, Class<?> clazz, Object arg) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return object.getClass().getMethod(method, clazz).invoke(object, arg);
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(Dependency dep) {
        Artifact artifact = dep.getArtifact();
        return this.factory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion(artifact.getVersion()), artifact.getProperty("type", artifact.getExtension()), artifact.getClassifier(), dep.getScope(), dep.isOptional());
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.eclipse.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        String premanagedVersion = null;
        String premanagedScope = null;
        DefaultDependencyNode current = new DefaultDependencyNode(parent, artifact, premanagedVersion, premanagedScope, this.getVersionSelectedFromRange(node.getVersionConstraint()));
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.eclipse.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        return constraint.getRange().toString();
    }
}

