/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.crypto;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionResult;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Named
@Singleton
public class DefaultSettingsDecrypter
implements SettingsDecrypter {
    private final SecDispatcher securityDispatcher;

    @Inject
    public DefaultSettingsDecrypter(@Named(value="maven") SecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            Object object = server.clone();
            servers.add((Server)object);
            try {
                ((Server)object).setPassword(this.decrypt(((Server)object).getPassword()));
            }
            catch (SecDispatcherException secDispatcherException) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for server " + ((IdentifiableBase)object).getId() + ": " + secDispatcherException.getMessage(), SettingsProblem.Severity.ERROR, "server: " + ((IdentifiableBase)object).getId(), -1, -1, secDispatcherException));
            }
            try {
                ((Server)object).setPassphrase(this.decrypt(((Server)object).getPassphrase()));
            }
            catch (SecDispatcherException secDispatcherException) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt passphrase for server " + ((IdentifiableBase)object).getId() + ": " + secDispatcherException.getMessage(), SettingsProblem.Severity.ERROR, "server: " + ((IdentifiableBase)object).getId(), -1, -1, secDispatcherException));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy : request.getProxies()) {
            Object object = proxy.clone();
            proxies.add((Proxy)object);
            try {
                ((Proxy)object).setPassword(this.decrypt(((Proxy)object).getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for proxy " + ((IdentifiableBase)object).getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + ((IdentifiableBase)object).getId(), -1, -1, e));
            }
        }
        return new DefaultSettingsDecryptionResult(servers, proxies, problems);
    }

    private String decrypt(String str) throws SecDispatcherException {
        return str == null ? null : this.securityDispatcher.decrypt(str);
    }
}

