/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveProjectArtifact
implements Artifact {
    private final Artifact artifact;
    private final MavenProject project;

    public ActiveProjectArtifact(MavenProject project, Artifact artifact) {
        this.artifact = artifact;
        this.project = project;
        artifact.setFile(project.getArtifact().getFile());
        artifact.setResolved(true);
    }

    @Override
    public File getFile() {
        return this.project.getArtifact().getFile();
    }

    @Override
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.artifact.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.artifact.setVersion(version);
    }

    @Override
    public String getScope() {
        return this.artifact.getScope();
    }

    @Override
    public String getType() {
        return this.artifact.getType();
    }

    @Override
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public boolean hasClassifier() {
        return this.artifact.hasClassifier();
    }

    @Override
    public void setFile(File destination) {
        this.artifact.setFile(destination);
        this.project.getArtifact().setFile(destination);
    }

    @Override
    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    @Override
    public void setBaseVersion(String baseVersion) {
        this.artifact.setBaseVersion(baseVersion);
    }

    @Override
    public String getId() {
        return this.artifact.getId();
    }

    @Override
    public String getDependencyConflictId() {
        return this.artifact.getDependencyConflictId();
    }

    @Override
    public void addMetadata(ArtifactMetadata metadata) {
        this.artifact.addMetadata(metadata);
    }

    @Override
    public Collection<ArtifactMetadata> getMetadataList() {
        return this.artifact.getMetadataList();
    }

    @Override
    public void setRepository(ArtifactRepository remoteRepository) {
        this.artifact.setRepository(remoteRepository);
    }

    @Override
    public ArtifactRepository getRepository() {
        return this.artifact.getRepository();
    }

    @Override
    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.artifact.updateVersion(version, localRepository);
    }

    @Override
    public String getDownloadUrl() {
        return this.artifact.getDownloadUrl();
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.artifact.setDownloadUrl(downloadUrl);
    }

    @Override
    public ArtifactFilter getDependencyFilter() {
        return this.artifact.getDependencyFilter();
    }

    @Override
    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.artifact.setDependencyFilter(artifactFilter);
    }

    @Override
    public ArtifactHandler getArtifactHandler() {
        return this.artifact.getArtifactHandler();
    }

    @Override
    public List<String> getDependencyTrail() {
        return this.artifact.getDependencyTrail();
    }

    @Override
    public void setDependencyTrail(List<String> dependencyTrail) {
        this.artifact.setDependencyTrail(dependencyTrail);
    }

    @Override
    public void setScope(String scope) {
        this.artifact.setScope(scope);
    }

    @Override
    public VersionRange getVersionRange() {
        return this.artifact.getVersionRange();
    }

    @Override
    public void setVersionRange(VersionRange newRange) {
        this.artifact.setVersionRange(newRange);
    }

    @Override
    public void selectVersion(String version) {
        this.artifact.selectVersion(version);
    }

    @Override
    public void setGroupId(String groupId) {
        this.artifact.setGroupId(groupId);
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifact.setArtifactId(artifactId);
    }

    @Override
    public boolean isSnapshot() {
        return this.artifact.isSnapshot();
    }

    @Override
    public int compareTo(Artifact a) {
        return this.artifact.compareTo(a);
    }

    @Override
    public void setResolved(boolean resolved) {
        this.artifact.setResolved(resolved);
    }

    @Override
    public boolean isResolved() {
        return this.artifact.isResolved();
    }

    @Override
    public void setResolvedVersion(String version) {
        this.artifact.setResolvedVersion(version);
    }

    @Override
    public void setArtifactHandler(ArtifactHandler handler) {
        this.artifact.setArtifactHandler(handler);
    }

    public String toString() {
        return "active project artifact:\n\tartifact = " + this.artifact + ";\n\tproject: " + this.project;
    }

    @Override
    public boolean isRelease() {
        return this.artifact.isRelease();
    }

    @Override
    public void setRelease(boolean release) {
        this.artifact.setRelease(release);
    }

    @Override
    public List<ArtifactVersion> getAvailableVersions() {
        return this.artifact.getAvailableVersions();
    }

    @Override
    public void setAvailableVersions(List<ArtifactVersion> versions) {
        this.artifact.setAvailableVersions(versions);
    }

    @Override
    public boolean isOptional() {
        return this.artifact.isOptional();
    }

    @Override
    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.artifact.getSelectedVersion();
    }

    @Override
    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.artifact.isSelectedVersionKnown();
    }

    @Override
    public void setOptional(boolean optional) {
        this.artifact.setOptional(optional);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getGroupId().hashCode();
        result = 37 * result + this.getArtifactId().hashCode();
        result = 37 * result + this.getType().hashCode();
        if (this.getVersion() != null) {
            result = 37 * result + this.getVersion().hashCode();
        }
        result = 37 * result + (this.getClassifier() != null ? this.getClassifier().hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (!a.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (!a.getArtifactId().equals(this.getArtifactId())) {
            return false;
        }
        if (!a.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (!a.getType().equals(this.getType())) {
            return false;
        }
        return !(a.getClassifier() == null ? this.getClassifier() != null : !a.getClassifier().equals(this.getClassifier()));
    }

    public ArtifactMetadata getMetadata(Class<?> metadataClass) {
        return this.artifact.getMetadata(metadataClass);
    }
}

