/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.parser;

import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.core.errorcollection.SyntaxException;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.parser.GrammarErrorListener;
import io.intino.magritte.builder.parser.antlr.ModelGenerator;
import io.intino.magritte.builder.parser.antlr.TaraErrorStrategy;
import io.intino.magritte.lang.grammar.TaraGrammar;
import io.intino.magritte.lang.grammar.TaraLexer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Parser {
    private static final Logger LOG = Logger.getGlobal();
    private final File file;
    private final CompilerConfiguration.Language language;
    private final String outDsl;
    private final TaraGrammar grammar;
    private TaraGrammar.RootContext rootContext;

    public Parser(File file, CompilerConfiguration.Language language, String sourceEncoding, String outDsl) throws IOException {
        this.file = file;
        this.language = language;
        this.outDsl = outDsl;
        TaraLexer lexer = new TaraLexer(CharStreams.fromString(Files.readString(file.toPath(), Charset.forName(sourceEncoding)).trim()));
        lexer.reset();
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        this.grammar = new TaraGrammar(tokens);
        this.grammar.setErrorHandler(new TaraErrorStrategy());
        this.grammar.addErrorListener(new GrammarErrorListener());
    }

    public void parse() throws SyntaxException {
        try {
            this.rootContext = this.grammar.root();
        }
        catch (RecognitionException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            this.throwError(e);
        }
    }

    public Model convert() throws SyntaxException {
        try {
            ParseTreeWalker walker = new ParseTreeWalker();
            ModelGenerator extractor = new ModelGenerator(this.file.getPath(), this.language, this.outDsl);
            walker.walk(extractor, this.rootContext);
            if (!extractor.getErrors().isEmpty()) {
                throw extractor.getErrors().get(0);
            }
            return extractor.getModel();
        }
        catch (RecognitionException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            return this.throwError(e);
        }
    }

    private Model throwError(RecognitionException e) throws SyntaxException {
        org.antlr.v4.runtime.Parser recognizer = (org.antlr.v4.runtime.Parser)e.getRecognizer();
        Token token = recognizer.getCurrentToken();
        throw new SyntaxException("Syntax error in " + this.file.getName(), token.getLine(), token.getCharPositionInLine(), this.getExpectedTokens(recognizer));
    }

    private String getExpectedTokens(org.antlr.v4.runtime.Parser recognizer) {
        try {
            return recognizer.getExpectedTokens().toString(recognizer.getVocabulary());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return "";
        }
    }
}

