/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.model;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParameterImpl
implements Parameter {
    private final List<Object> values = new ArrayList<Object>();
    private final List<Object> originalValues = new ArrayList<Object>();
    private String name;
    private int position;
    private String aspect = "";
    private String scope;
    private String file;
    private int line;
    private int column;
    private String metric;
    private VariableRule rule;
    private Primitive inferredType;
    private boolean multiple;
    private boolean hasReferenceValue = false;
    private List<Tag> flags = new ArrayList<Tag>();
    private Node container;
    private String uid;

    public ParameterImpl(String name, int position, String metric, List<Object> values) {
        this.name = name;
        this.position = position;
        this.metric = metric == null ? "" : metric;
        this.addOriginalValues(values);
        this.addValues(values);
    }

    public ParameterImpl(int position, String metric, List<Object> values) {
        this("", position, metric, values);
    }

    @Override
    public Node container() {
        return this.container;
    }

    public void owner(Node owner) {
        this.container = owner;
    }

    @Override
    public Primitive type() {
        return this.inferredType;
    }

    @Override
    public void type(Primitive type) {
        this.inferredType = type;
        this.hasReferenceValue = Primitive.REFERENCE.equals((Object)this.inferredType);
    }

    @Override
    public String aspect() {
        return this.aspect;
    }

    @Override
    public void aspect(String aspect) {
        this.aspect = aspect;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public void multiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public List<Tag> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    @Override
    public void flags(List<Tag> flags) {
        this.flags = flags;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.inferredType, this.values));
    }

    @Override
    public List<Object> originalValues() {
        return this.originalValues;
    }

    private NodeRoot model() {
        Node container = this.container;
        while (!(container instanceof NodeRoot)) {
            container = container.container();
        }
        return (NodeRoot)container;
    }

    @Override
    public void values(List<Object> objects) {
        this.addValues(objects);
    }

    @Override
    public VariableRule rule() {
        return this.rule;
    }

    @Override
    public void rule(VariableRule rule) {
        this.rule = rule;
    }

    @Override
    public void scope(String scope) {
        this.scope = scope;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public String file() {
        return this.file;
    }

    @Override
    public void file(String file) {
        this.file = file;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public void column(int column) {
        this.column = column;
    }

    @Override
    public String metric() {
        return this.metric;
    }

    @Override
    public void metric(String metric) {
        this.metric = metric == null ? "" : metric;
    }

    @Override
    public boolean isVariableInit() {
        return false;
    }

    @Override
    public boolean hasReferenceValue() {
        return this.hasReferenceValue;
    }

    public String toString() {
        return this.name + ":" + this.position + ":" + this.values;
    }

    @Override
    public void substituteValues(List<?> newValues) {
        this.addValues(newValues);
    }

    @Override
    public String getUID() {
        if (this.uid == null) {
            this.uid = "" + Variable.NativeCounter.next(this.container(), this.name());
        }
        return this.uid;
    }

    private void addValues(List<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    private void addOriginalValues(List<Object> values) {
        this.originalValues.clear();
        this.originalValues.addAll(values);
    }
}

