/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.model;

import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeReference
implements Node {
    private Node container;
    private NodeImpl destination;
    private String reference;
    private String file;
    private int line;
    private String doc;
    private List<Tag> flags = new ArrayList<Tag>();
    private List<Tag> annotations = new ArrayList<Tag>();
    private List<String> uses = new ArrayList<String>();
    private boolean has;
    private String language;

    public NodeReference(String reference) {
        this.reference = reference;
    }

    public NodeReference(NodeImpl destination) {
        this.destination = destination;
        this.reference = destination.qualifiedName();
    }

    public String getReference() {
        return this.reference;
    }

    public NodeImpl destination() {
        return this.destination;
    }

    public void destination(NodeImpl destination) {
        this.destination = destination;
    }

    public String layerQualifiedName() {
        return ((NodeImpl)this.container).layerQualifiedName() + "$" + this.destination.name();
    }

    @Override
    public String name() {
        return this.destination != null ? this.destination.name() : "";
    }

    @Override
    public void name(String name) {
    }

    @Override
    public String file() {
        return this.file;
    }

    @Override
    public void file(String file) {
        this.file = file;
    }

    @Override
    public String languageName() {
        return this.language;
    }

    @Override
    public void languageName(String language) {
        this.language = language;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public void doc(String doc) {
        this.doc = doc;
    }

    @Override
    public boolean isSub() {
        return false;
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    @Override
    public List<Node> subs() {
        return Collections.unmodifiableList(this.destination.subs());
    }

    @Override
    public Node container() {
        return this.container;
    }

    @Override
    public List<String> uses() {
        return this.uses;
    }

    @Override
    public void container(Node container) {
        this.container = container;
    }

    @Override
    public boolean isTerminal() {
        return this.is(Tag.Terminal);
    }

    @Override
    public boolean isAbstract() {
        return this.is(Tag.Abstract);
    }

    @Override
    public boolean isAspect() {
        return this.destination.isAspect();
    }

    @Override
    public boolean isMetaAspect() {
        return this.destination.isMetaAspect();
    }

    @Override
    public boolean is(Tag tag) {
        return this.destination.is(tag) || this.flags().contains((Object)tag);
    }

    @Override
    public boolean into(Tag tag) {
        return this.destination.into(tag) || this.annotations().contains((Object)tag);
    }

    @Override
    public List<Tag> annotations() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.destination.annotations());
        this.annotations.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        return Collections.unmodifiableList(tags);
    }

    @Override
    public List<Tag> flags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.flags.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        if (this.isHas()) {
            tags.addAll(this.destination.flags());
        }
        return Collections.unmodifiableList(tags);
    }

    @Override
    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    @Override
    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    @Override
    public void addUses(List<String> uses) {
        this.uses.addAll(uses);
    }

    @Override
    public Node parent() {
        return null;
    }

    @Override
    public String parentName() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return this.destination.isAnonymous();
    }

    @Override
    public String qualifiedName() {
        return this.container.qualifiedName() + "." + this.destination.name();
    }

    @Override
    public String type() {
        return this.destination.type();
    }

    @Override
    public List<String> types() {
        return this.destination.types();
    }

    @Override
    public List<String> secondaryTypes() {
        return this.destination.secondaryTypes();
    }

    @Override
    public void type(String type) {
    }

    @Override
    public void stashNodeName(String name) {
    }

    @Override
    public Node resolve() {
        return this;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public List<Parameter> parameters() {
        return Collections.emptyList();
    }

    @Override
    public List<Node> siblings() {
        ArrayList<Node> components = new ArrayList<Node>(this.container.components());
        components.remove(this);
        return Collections.unmodifiableList(components);
    }

    @Override
    public List<Node> components() {
        return Collections.unmodifiableList(this.destination.components());
    }

    @Override
    public List<Rule> rulesOf(Node component) {
        return this.destination.rulesOf(component);
    }

    public boolean contains(Node nodeContainer) {
        return false;
    }

    @Override
    public List<Variable> variables() {
        return Collections.unmodifiableList(this.destination.variables());
    }

    @Override
    public List<Node> referenceComponents() {
        return Collections.unmodifiableList(this.destination.referenceComponents());
    }

    @Override
    public Node destinyOfReference() {
        return this.destination;
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.destination.children());
    }

    @Override
    public List<Aspect> appliedAspects() {
        return Collections.unmodifiableList(this.destination.appliedAspects());
    }

    @Override
    public String toString() {
        return this.destination != null ? this.qualifiedName() : this.reference;
    }
}

