/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.model;

import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.builder.model.ParameterImpl;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class NodeImpl
implements Node {
    private String file;
    private int line;
    private Node container;
    private String type;
    private String doc;
    private boolean sub;
    private String name;
    private String parentName;
    private Node parent;
    private boolean anonymous = true;
    private boolean dirty;
    private boolean virtual;
    private String hashCode;
    private String language;
    private String uid;
    private final String text;
    private final List<String> uses = new ArrayList<String>();
    private final Map<Node, List<Rule>> components = new LinkedHashMap<Node, List<Rule>>();
    private final List<Tag> flags = new ArrayList<Tag>();
    private final List<Tag> annotations = new ArrayList<Tag>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<Variable> variables = new ArrayList<Variable>();
    private final List<Aspect> aspects = new ArrayList<Aspect>();
    private final List<Node> children = new ArrayList<Node>();
    private List<AspectConstraint> aspectConstraints;
    private List<String> context = new ArrayList<String>();

    public NodeImpl(String text) {
        this.text = text;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
        this.anonymous = false;
    }

    @Override
    public String file() {
        return this.file;
    }

    @Override
    public void file(String file) {
        this.file = file;
    }

    @Override
    public String languageName() {
        return this.language;
    }

    @Override
    public void languageName(String language) {
        this.language = language;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public void doc(String doc) {
        this.doc = this.doc == null ? doc : this.doc + "\\n" + doc.trim();
    }

    @Override
    public boolean isSub() {
        return this.sub;
    }

    public void setSub(boolean sub) {
        this.sub = sub;
    }

    @Override
    public List<Node> subs() {
        ArrayList nodes = new ArrayList();
        this.children().stream().filter(Node::isSub).forEach(c -> {
            nodes.add(c);
            nodes.addAll(c.subs());
        });
        return Collections.unmodifiableList(nodes);
    }

    @Override
    public Node container() {
        return this.container;
    }

    @Override
    public List<String> uses() {
        return this.uses;
    }

    @Override
    public void container(Node container) {
        this.container = container;
    }

    @Override
    public boolean isTerminal() {
        return this.flags.contains((Object)Tag.Terminal);
    }

    @Override
    public boolean isAbstract() {
        return this.flags.contains((Object)Tag.Abstract) || this.children().stream().anyMatch(Node::isSub);
    }

    @Override
    public boolean isAspect() {
        return "Aspect".equals(this.type()) || this.is(Tag.Aspect);
    }

    @Override
    public boolean isMetaAspect() {
        return "MetaAspect".equals(this.type());
    }

    @Override
    public List<Node.AspectConstraint> aspectConstraints() {
        return Collections.emptyList();
    }

    public void aspectConstraints(List<String> constraints) {
        this.aspectConstraints = constraints.stream().map(AspectConstraint::new).collect(Collectors.toList());
    }

    @Override
    public boolean is(Tag tag) {
        return this.flags.contains((Object)tag);
    }

    @Override
    public boolean into(Tag tag) {
        return this.annotations.contains((Object)tag);
    }

    @Override
    public List<Tag> annotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public List<Tag> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    @Override
    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    @Override
    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    @Override
    public void addUses(List<String> imports) {
        this.uses.addAll(imports);
    }

    @Override
    public Node parent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public String parentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    public NodeImpl isAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    @Override
    public String qualifiedName() {
        String containerQN = this.container.qualifiedName();
        String name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format(this.name()).toString();
        return (String)(containerQN.isEmpty() ? "" : containerQN + ".") + (String)(name == null ? "[anonymous@" + this.shortType() + "]" : name);
    }

    public String layerQualifiedName() {
        String containerQn = this.container instanceof Model ? "" : ((NodeImpl)this.container).layerQualifiedName();
        String name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format(this.name()).toString();
        return (String)(containerQn.isEmpty() ? "" : containerQn + "$") + (name == null ? this.newUUID() : name);
    }

    public String layerQn() {
        Object name;
        String containerQn = this.container instanceof Model ? "" : ((NodeImpl)this.container).layerQn();
        Object object = name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format(this.name()).toString();
        if (name != null && this.is(Tag.Decorable)) {
            name = "Abstract" + (String)name;
        }
        return (String)(containerQn.isEmpty() ? "" : containerQn + "$") + (String)(name == null ? this.newUUID() : name);
    }

    private String shortType() {
        return this.type.contains(".") ? this.type.substring(this.type.lastIndexOf(".") + 1) : this.type;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public List<String> types() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.type());
        types.addAll(this.secondaryTypes());
        return Collections.unmodifiableList(types);
    }

    @Override
    public List<String> secondaryTypes() {
        Set types = this.appliedAspects().stream().map(Aspect::type).collect(Collectors.toSet());
        if (this.parent != null) {
            types.addAll(this.parent.types());
        }
        return List.copyOf(types);
    }

    @Override
    public void type(String type) {
        this.type = type;
    }

    @Override
    public void stashNodeName(String name) {
    }

    @Override
    public List<String> metaTypes() {
        return this.context;
    }

    @Override
    public void metaTypes(List<String> context) {
        this.context = new ArrayList<String>(context);
    }

    @Override
    public Node resolve() {
        return this;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public List<Parameter> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void addParameter(String name, String facet, int position, String extension, int line, int column, List<Object> values) {
        ParameterImpl parameter = new ParameterImpl(name, position, extension, values);
        parameter.aspect(facet);
        parameter.file(this.file);
        parameter.line(line);
        parameter.column(column);
        parameter.owner(this);
        this.parameters.add(parameter);
    }

    public void add(Parameter parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List<Node> siblings() {
        ArrayList<Node> siblings = new ArrayList<Node>(this.container().components());
        siblings.remove(this);
        return Collections.unmodifiableList(siblings);
    }

    @Override
    public List<Node> components() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.components.keySet()));
    }

    @Override
    public void add(Node node, List<Rule> rules) {
        this.components.put(node, rules == null ? new ArrayList() : new ArrayList<Rule>(rules));
    }

    @Override
    public List<Rule> rulesOf(Node component) {
        return this.components.get(component);
    }

    public boolean contains(Node nodeContainer) {
        return nodeContainer != null && this.components.containsKey(nodeContainer);
    }

    public void remove(Node node) {
        if (node != null) {
            this.components.remove(node);
        }
    }

    @Override
    public List<Variable> variables() {
        return Collections.unmodifiableList(this.variables);
    }

    public void add(Variable ... variables) {
        Collections.addAll(this.variables, variables);
    }

    public void add(int pos, Variable ... variables) {
        this.variables.addAll(pos, Arrays.asList(variables));
    }

    @Override
    public List<Node> referenceComponents() {
        return this.components.keySet().stream().filter(include -> include instanceof NodeReference).map(include -> (NodeReference)include).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Node destinyOfReference() {
        return this;
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    @Override
    public List<Aspect> appliedAspects() {
        return Collections.unmodifiableList(this.aspects);
    }

    @Override
    public void applyAspects(Aspect ... aspects) {
        Collections.addAll(this.aspects, aspects);
    }

    @Override
    public String toString() {
        return this.type + " " + this.qualifiedName();
    }

    public String text() {
        return this.text;
    }

    private String newUUID() {
        if (this.uid == null) {
            this.uid = UUID.randomUUID().toString();
        }
        return this.is(Tag.Instance) ? this.uid : Format.firstUpperCase().format(this.uid).toString();
    }

    public void absorb(NodeImpl node) {
        this.components.putAll(node.components);
        this.variables.addAll(node.variables);
        this.children.addAll(node.children);
        for (Node child : node.children) {
            ((NodeImpl)child).setParent(this);
        }
        this.annotations.addAll(node.annotations);
        this.flags.addAll(node.flags.stream().filter(t -> !t.equals((Object)Tag.Abstract)).collect(Collectors.toList()));
        this.aspects.addAll(node.aspects);
        this.flags.remove((Object)Tag.Abstract);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    public String getHashCode() {
        return this.hashCode;
    }

    private static class AspectConstraint
    implements Node.AspectConstraint,
    Cloneable {
        private Node node;
        private boolean negated = false;
        private String name;

        AspectConstraint(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Node node() {
            return this.node;
        }

        public void node(Node node) {
            this.node = node;
        }

        public AspectConstraint clone() throws CloneNotSupportedException {
            return (AspectConstraint)super.clone();
        }

        public String toString() {
            return "with " + this.node().qualifiedName();
        }
    }
}

