/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.natives;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Primitive;
import java.io.File;
import java.util.Arrays;

class NativeParameterAdapter
extends Generator
implements Adapter<Parameter>,
TemplateTags {
    private final Configuration.Artifact.Model.Level level;
    private final String aPackage;
    private final File importsFile;

    NativeParameterAdapter(Language language, String outDSL, Configuration.Artifact.Model.Level level, String workingPackage, String languageWorkingPackage, String aPackage, File importsFile) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.level = level;
        this.aPackage = aPackage;
        this.importsFile = importsFile;
    }

    @Override
    public void adapt(Parameter parameter, FrameBuilderContext context) {
        Arrays.stream(TypesProvider.getTypes(parameter)).forEach(context::add);
        this.createFrame(context, parameter);
    }

    private void createFrame(FrameBuilderContext context, Parameter parameter) {
        this.createNativeFrame(context, parameter);
    }

    private void createNativeFrame(FrameBuilderContext context, Parameter parameter) {
        if (!(parameter.values().get(0) instanceof Primitive.Expression)) {
            return;
        }
        Primitive.Expression body = (Primitive.Expression)parameter.values().get(0);
        String value = body.get();
        NativeFormatter formatter = new NativeFormatter(this.language, this.outDsl, this.aPackage, this.workingPackage, this.languageWorkingPackage, this.level.compareLevelWith(Configuration.Artifact.Model.Level.Solution) == 0, this.importsFile);
        if (Primitive.FUNCTION.equals((Object)parameter.type())) {
            formatter.fillFrameForFunctionParameter(parameter, value, context);
        } else {
            formatter.fillFrameNativeParameter(context, parameter, value);
        }
    }
}

