/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.magritte.builder.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.lang.model.EmptyNode;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.variable.NativeCustomWordRule;
import io.intino.magritte.lang.model.rules.variable.NativeRule;
import io.intino.magritte.lang.model.rules.variable.NativeWordRule;
import io.intino.magritte.lang.model.rules.variable.VariableCustomRule;
import io.intino.magritte.lang.model.rules.variable.WordRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class LayerVariableAdapter
extends Generator
implements Adapter<Variable>,
TemplateTags {
    private Configuration.Artifact.Model.Level modelLevel;

    LayerVariableAdapter(Language language, String generatedLanguage, Configuration.Artifact.Model.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        super(language, generatedLanguage, workingPackage, languageWorkingPackage);
        this.modelLevel = modelLevel;
    }

    @Override
    public void adapt(Variable variable, FrameBuilderContext context) {
        FrameBuilder ruleBuilder;
        TypesProvider.getTypes(variable, this.modelLevel).forEach(context::add);
        context.add("name", variable.name());
        context.add("generatedLanguage", this.outDsl.toLowerCase());
        context.add("workingPackage", this.workingPackage.toLowerCase());
        context.add("language", this.language.languageName().toLowerCase());
        Node container = variable.container();
        context.add("containerName", container.name());
        context.add("qn", NameFormatter.cleanQn(this.buildQN(container)));
        if (variable.values().stream().anyMatch(Objects::nonNull) && !(variable.values().get(0) instanceof EmptyNode)) {
            this.addValues(variable, context);
        }
        if (variable.rule() != null && (ruleBuilder = this.ruleToFrame(variable.rule())) != null) {
            context.add("rule", ruleBuilder.toFrame());
        }
        context.add("type", this.getType(variable));
        if (Primitive.WORD.equals((Object)variable.type())) {
            this.fillWordVariable(variable, context);
        } else if (variable.type().equals((Object)Primitive.FUNCTION) || variable.flags().contains((Object)Tag.Reactive)) {
            this.fillNativeVariable(context, variable);
        }
    }

    private void fillWordVariable(Variable variable, FrameBuilderContext context) {
        if (variable.rule() instanceof VariableCustomRule || variable.rule() instanceof NativeCustomWordRule || variable.rule() instanceof WordRule && ((WordRule)variable.rule()).isCustom()) {
            context.add("outDefined");
        } else {
            List<String> allowedWords = variable.rule() instanceof NativeRule ? ((NativeWordRule)variable.rule()).words() : ((WordRule)variable.rule()).words();
            context.add("words", allowedWords.toArray(new Object[0]));
        }
    }

    private String buildQN(Node node) {
        return NameFormatter.getQn(node instanceof NodeReference ? ((NodeReference)node).destination() : node, this.workingPackage.toLowerCase());
    }

    private void addValues(Variable variable, FrameBuilderContext context) {
        if (Primitive.WORD.equals((Object)variable.type())) {
            context.add("wordValues", this.getWordValues(variable));
        } else if (Primitive.STRING.equals((Object)variable.type())) {
            context.add("values", this.asString(variable.values()));
        } else {
            context.add("values", variable.values().toArray());
        }
    }

    private String[] getWordValues(Variable variable) {
        return (String[])variable.values().stream().map(Object::toString).toArray(String[]::new);
    }

    private String[] asString(List<Object> objects) {
        return (String[])objects.stream().map(object -> "\"" + object.toString() + "\"").toArray(String[]::new);
    }

    private void fillNativeVariable(FrameBuilderContext context, Variable variable) {
        Object next = variable.values().isEmpty() || !(variable.values().get(0) instanceof Primitive.Expression) ? null : variable.values().get(0);
        NativeFormatter adapter = new NativeFormatter(this.language, this.outDsl, NativeFormatter.calculatePackage(variable.container()), this.workingPackage, this.languageWorkingPackage, this.modelLevel.equals((Object)Configuration.Artifact.Model.Level.Solution), null);
        if (Primitive.FUNCTION.equals((Object)variable.type())) {
            adapter.fillFrameForFunctionVariable(variable, next, context);
            this.imports.addAll(new ArrayList<String>(((NativeRule)variable.rule()).imports()));
        } else {
            adapter.fillFrameNativeVariable(context, variable, next);
        }
    }
}

