/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.Language;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.NodeAdapter;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LayerFrameCreator
implements TemplateTags {
    private final Map<Class, Adapter> adapters;
    private final String outDsl;
    private final String workingPackage;
    private Node initNode = null;
    private NodeAdapter nodeAdapter;
    private LayerVariableAdapter variableAdapter;

    private LayerFrameCreator(String outDsl, Model model, Language language, Configuration.Artifact.Model.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        this.outDsl = outDsl;
        this.workingPackage = workingPackage;
        this.adapters = new HashMap<Class, Adapter>();
        this.variableAdapter = new LayerVariableAdapter(language, outDsl, modelLevel, workingPackage, languageWorkingPackage);
        this.adapters.put(Variable.class, this.variableAdapter);
        this.nodeAdapter = new NodeAdapter(outDsl, model, modelLevel, language, null, workingPackage, languageWorkingPackage);
        this.adapters.put(Node.class, this.nodeAdapter);
    }

    public LayerFrameCreator(CompilerConfiguration conf, String language, Model model) {
        this(conf.model().outDsl(), model, conf.model().language().get(), conf.model().level(), conf.workingPackage(), conf.model().language().generationPackage());
    }

    public Map.Entry<String, Frame> create(Node node) {
        this.initNode = node;
        this.nodeAdapter.getImports().clear();
        this.variableAdapter.getImports().clear();
        this.nodeAdapter.setInitNode(this.initNode);
        FrameBuilder builder = new FrameBuilder("Layer").add("generatedLanguage", this.outDsl).add("workingPackage", this.workingPackage);
        this.addSlot(builder, node);
        this.addNodeImports(builder);
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateLayerPath(node, this.addWorkingPackage(builder)), builder.toFrame());
    }

    private void addSlot(FrameBuilder builder, Node node) {
        if (node instanceof NodeReference || node.is(Tag.Instance)) {
            return;
        }
        builder.add("node", new FrameBuilder().put(this.adapters).append(node).toFrame());
    }

    public Map.Entry<String, Frame> createDecorable(Node node) {
        FrameBuilder builder = new FrameBuilder("Layer", "decorable");
        String aPackage = this.addWorkingPackage(builder);
        builder.add("name", node.name());
        if (!(node.container() instanceof NodeRoot)) {
            builder.add("container", node.container().qualifiedName());
        }
        if (node.isAbstract()) {
            builder.add("abstract", true);
        }
        builder.add("decorableNode", node.components().stream().filter(c -> !c.isReference()).map(this::createDecorableFrame).toArray(Frame[]::new));
        return new AbstractMap.SimpleEntry<String, Frame>(this.calculateDecorablePath(node, aPackage), builder.toFrame());
    }

    private Frame createDecorableFrame(Node node) {
        FrameBuilder builder = new FrameBuilder("decorableNode").add("name", node.name());
        if (node.isAbstract()) {
            builder.add("abstract", "abstract");
        }
        builder.add("decorableNode", node.components().stream().filter(c -> !c.isReference()).map(this::createDecorableFrame).toArray(Frame[]::new));
        return builder.toFrame();
    }

    private String calculateLayerPath(Node node, String aPackage) {
        return aPackage + "." + (node.is(Tag.Decorable) ? "Abstract" : "") + Format.firstUpperCase().format(Format.javaValidName().format(node.name()).toString());
    }

    private String calculateDecorablePath(Node node, String aPackage) {
        return aPackage + (String)(node.container() instanceof Model ? "" : "." + node.container().qualifiedName().toLowerCase()) + "." + Format.firstUpperCase().format(Format.javaValidName().format(node.name()).toString());
    }

    private void addNodeImports(FrameBuilder builder) {
        HashSet<String> set = new HashSet<String>(this.nodeAdapter.getImports());
        set.addAll(this.variableAdapter.getImports());
        if (!set.isEmpty()) {
            builder.add("imports", set.toArray(new Object[0]));
        }
    }

    private String addWorkingPackage(FrameBuilder builder) {
        String packagePath = this.workingPackage.toLowerCase();
        if (!packagePath.isEmpty()) {
            builder.add("package", packagePath);
        }
        return packagePath.endsWith(".") ? packagePath.substring(0, packagePath.length() - 1) : packagePath;
    }
}

