/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.codegeneration.language;

import io.intino.Configuration;
import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.Language;
import io.intino.magritte.builder.codegeneration.TemplateTags;
import io.intino.magritte.builder.codegeneration.language.LanguageInheritanceManager;
import io.intino.magritte.builder.codegeneration.language.LanguageParameterAdapter;
import io.intino.magritte.builder.codegeneration.language.TerminalConstraintManager;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.model.NodeImpl;
import io.intino.magritte.builder.model.NodeReference;
import io.intino.magritte.builder.model.VariableReference;
import io.intino.magritte.builder.utils.Format;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeContainer;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Rule;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.Variable;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.model.rules.composition.NodeCustomRule;
import io.intino.magritte.lang.semantics.Assumption;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class LanguageModelAdapter
implements Adapter<Model>,
TemplateTags {
    private static final String FacetSeparator = ":";
    private final Configuration.Artifact.Model.Level level;
    private final String workingPackage;
    private final Set<Node> processed = new HashSet<Node>();
    private final String outDSL;
    private final Locale locale;
    private final Language language;
    private int rootNumber = 0;

    LanguageModelAdapter(String outDSL, Locale locale, Language language, Configuration.Artifact.Model.Level type, String workingPackage, String languageWorkingPackage) {
        this.outDSL = outDSL;
        this.locale = locale;
        this.language = language;
        this.level = type;
        this.workingPackage = workingPackage;
    }

    @Override
    public void adapt(Model model, FrameBuilderContext context) {
        this.initRoot(context);
        this.buildRootNodes(model, context);
        this.addInheritedRules(model, context);
    }

    private void initRoot(FrameBuilderContext root) {
        root.add("name", this.outDSL);
        root.add("terminal", this.level.equals((Object)Configuration.Artifact.Model.Level.Product));
        root.add("metaLanguage", this.language.languageName());
        root.add("locale", this.locale.getLanguage());
    }

    private void buildRootNodes(Model model, FrameBuilderContext root) {
        FrameBuilder builder = new FrameBuilder("node");
        this.createRuleFrame(model, builder, root);
        model.components().forEach(n -> {
            FrameBuilder rootNodeFrame = new FrameBuilder("root");
            rootNodeFrame.add("number", ++this.rootNumber);
            rootNodeFrame.add("language", this.outDSL);
            root.add("root", rootNodeFrame.toFrame());
            this.buildNode((Node)n, rootNodeFrame);
        });
    }

    private void buildNode(Node node, FrameBuilder root) {
        if (this.alreadyProcessed(node)) {
            return;
        }
        FrameBuilder frame = new FrameBuilder("node");
        if (!(node.isAbstract() || node.isAnonymous() || node.is(Tag.Instance))) {
            this.createRuleFrame(node, frame, root);
        } else if (node.is(Tag.Instance) && !node.isAnonymous()) {
            root.add("node", this.createInstanceFrame(node));
        }
        if (!node.isAnonymous()) {
            node.components().stream().filter(inner -> !(inner instanceof NodeReference)).forEach(n -> this.buildNode((Node)n, root));
        }
    }

    private void createRuleFrame(Node node, FrameBuilder builder, FrameBuilderContext root) {
        builder.add("name", this.name(node));
        this.addTypes(node, builder);
        this.addConstraints(node, builder);
        this.addAssumptions(node, builder);
        this.addDoc(node, builder);
        root.add("node", builder.toFrame());
    }

    private Frame createInstanceFrame(Node node) {
        FrameBuilder builder = new FrameBuilder("instance").add("qn", this.name(node));
        this.addTypes(node, builder);
        builder.add("path", this.outDSL);
        return builder.toFrame();
    }

    private void addInheritedRules(Model model, FrameBuilderContext root) {
        new LanguageInheritanceManager(root, this.instanceConstraints(), this.language, model).fill();
    }

    private List<String> instanceConstraints() {
        return this.language.catalog().entrySet().stream().filter(entry -> this.isInstance((Context)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isInstance(Context context) {
        return context.assumptions().stream().anyMatch(a -> a instanceof Assumption.Instance);
    }

    private void addDoc(Node node, FrameBuilder frame) {
        frame.add("doc", new FrameBuilder("doc").add("Layer", this.findLayer(node)).add("file", new File(node.file()).getName().replace("\\", "\\\\")).add("line", node.line()).add("doc", node.doc() != null ? this.format(node.doc()) : this.format(this.text(node))).toFrame());
    }

    private String text(Node node) {
        return node instanceof NodeImpl ? ((NodeImpl)node).text() : node.toString();
    }

    private String findLayer(Node node) {
        return node instanceof Model ? "" : LanguageModelAdapter.getQn(node, this.workingPackage);
    }

    private String format(String doc) {
        return doc.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
    }

    private void addTypes(Node node, FrameBuilder builder) {
        if (node.type() == null) {
            return;
        }
        FrameBuilder typesFrameBuilder = new FrameBuilder("nodeType");
        LinkedHashSet<String> typeSet = new LinkedHashSet<String>();
        typeSet.add(node.type());
        Collection<String> languageTypes = this.getLanguageTypes(node);
        if (languageTypes != null) {
            typeSet.addAll(languageTypes);
        }
        for (String type : typeSet) {
            typesFrameBuilder.add("type", type);
        }
        if (typesFrameBuilder.slots() > 0) {
            builder.add("nodeType", typesFrameBuilder.toFrame());
        }
    }

    private Collection<String> getLanguageTypes(Node node) {
        return this.language.types(node.type());
    }

    private boolean alreadyProcessed(Node node) {
        return !this.processed.add(node);
    }

    private void addConstraints(Node node, FrameBuilder builder) {
        FrameBuilder constraints = this.buildComponentConstraints(node);
        this.addTerminalConstrains(node, constraints);
        this.addContextConstraints(node, constraints);
        builder.add("constraints", constraints.toFrame());
    }

    private void addContextConstraints(Node node, FrameBuilder constraints) {
        if (node instanceof NodeImpl) {
            if (!node.isTerminal()) {
                this.addRequiredVariableRedefines(constraints, node);
            }
            this.addParameterConstraints(node.variables(), node.type().startsWith("Aspect") ? node.name() : "", constraints, LanguageParameterAdapter.terminalParameters(this.language, node) + this.terminalParameterIndex(constraints.toFrame()));
        }
        this.addMetaAspectConstraints(node, constraints);
        this.addAspectConstraints(node, constraints);
    }

    private int terminalParameterIndex(Frame constraints) {
        Iterator<Frame> iterator = constraints.frames("constraint");
        int index = 0;
        while (iterator.hasNext()) {
            if (!iterator.next().is("parameter")) continue;
            ++index;
        }
        return index;
    }

    private void addParameterConstraints(List<Variable> variables, String aspect, FrameBuilder constrainsFrame, int parentIndex) {
        int privateVariables = 0;
        for (int index = 0; index < variables.size(); ++index) {
            Variable variable = variables.get(index);
            if (!variable.isPrivate() && !this.finalWithValues(variable)) {
                new LanguageParameterAdapter(this.language, this.workingPackage, this.level).addParameterConstraint(constrainsFrame, aspect, parentIndex + index - privateVariables, variable, "constraint");
                continue;
            }
            ++privateVariables;
        }
    }

    private boolean finalWithValues(Variable variable) {
        return variable.isFinal() && !variable.values().isEmpty();
    }

    private void addMetaAspectConstraints(Node node, FrameBuilder constraints) {
        node.components().stream().filter(Node::isMetaAspect).forEach(aspectNode -> {
            List<Node.AspectConstraint> with = aspectNode.aspectConstraints();
            FrameBuilder builder = new FrameBuilder("constraint", "metaAspect").add("value", aspectNode.qualifiedName());
            if (with != null && !with.isEmpty()) {
                builder.add("with", with.stream().map(c -> c.node().qualifiedName()).toArray(Object[]::new));
            }
            constraints.add("constraint", builder.toFrame());
        });
    }

    private void addAspectConstraints(Node node, FrameBuilder constraintsBuilder) {
        node.components().stream().filter(Node::isAspect).forEach(aspectNode -> {
            if (aspectNode.isAbstract()) {
                return;
            }
            if (aspectNode.isReference()) {
                aspectNode = aspectNode.destinyOfReference();
            }
            FrameBuilder builder = new FrameBuilder("constraint", "aspect").add("value", aspectNode.qualifiedName());
            builder.add("terminal", "" + aspectNode.isTerminal());
            if (aspectNode.aspectConstraints() != null && !aspectNode.aspectConstraints().isEmpty()) {
                for (Node.AspectConstraint constraint : aspectNode.aspectConstraints()) {
                    builder.add("with", constraint.node().name());
                }
            }
            if (aspectNode.flags().contains((Object)Tag.Required)) {
                builder.add("required", "true");
            }
            this.addParameterConstraints(aspectNode.variables(), aspectNode.name(), builder, 0);
            this.addComponentsConstraints(builder, (Node)aspectNode);
            this.addTerminalConstrains((Node)aspectNode, builder);
            constraintsBuilder.add("constraint", builder.toFrame());
        });
        this.addTerminalAspects(node, constraintsBuilder);
    }

    private void addTerminalAspects(Node node, FrameBuilder context) {
        List<Constraint> facetAllows = this.language.constraints(node.type()).stream().filter(allow -> allow instanceof Constraint.Aspect && ((Constraint.Aspect)allow).terminal()).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, node).addConstraints(facetAllows, context);
    }

    private void addTerminalConstrains(Node container, FrameBuilder frame) {
        List<Constraint> constraints = this.language.constraints(container.type());
        List<Constraint> terminalConstraints = constraints.stream().filter(c -> this.validComponent(container, (Constraint)c) || this.validParameter(container, (Constraint)c)).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, container).addConstraints(terminalConstraints, frame);
    }

    private boolean validParameter(Node container, Constraint c) {
        if (!(c instanceof Constraint.Parameter)) {
            return false;
        }
        return ((Constraint.Parameter)c).flags().contains((Object)Tag.Terminal) && !this.isRedefined((Constraint.Parameter)c, container.variables());
    }

    private boolean validComponent(Node container, Constraint c) {
        if (!(c instanceof Constraint.Component)) {
            return false;
        }
        return this.is(this.annotations(c), Tag.Instance) && !this.sizeComplete(container, this.typeOf(c));
    }

    private boolean isRedefined(Constraint.Parameter allow, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(allow.name())) continue;
            return true;
        }
        return false;
    }

    private String typeOf(Constraint constraint) {
        return ((Constraint.Component)constraint).type();
    }

    private boolean sizeComplete(NodeContainer container, String type) {
        List components = container.components().stream().filter(node -> node.type().equals(type)).collect(Collectors.toList());
        return !components.isEmpty() && container.sizeOf((Node)components.get(0)).max() == components.size();
    }

    private void addRequiredVariableRedefines(FrameBuilder constraints, Node node) {
        node.variables().stream().filter(variable -> variable.isTerminal() && variable instanceof VariableReference && !((VariableReference)variable).getDestiny().isTerminal()).forEach(variable -> constraints.add("constraint", new FrameBuilder("redefine", "constraint").add("name", variable.name()).add("supertype", (Object)variable.type()).toFrame()));
    }

    private void addAssumptions(Node node, FrameBuilder frame) {
        FrameBuilder assumptions = this.buildAssumptions(node);
        if (assumptions.slots() != 0) {
            frame.add("assumptions", assumptions.toFrame());
        }
    }

    private FrameBuilder buildAssumptions(Node node) {
        FrameBuilder assumptions = new FrameBuilder("assumptions");
        assumptions.add("assumption", new FrameBuilder("stashNodeName").add("value", LanguageModelAdapter.name(node, this.workingPackage)));
        this.addAnnotationAssumptions(node, assumptions);
        return assumptions;
    }

    public static String name(Node owner, String workingPackage) {
        return owner instanceof Model ? "" : Format.withDollar().format(Format.noPackage().format(LanguageModelAdapter.getQn(owner, workingPackage))).toString();
    }

    public static String getQn(Node node, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.qualifiedName().format(LanguageModelAdapter.layerQn(node)).toString();
    }

    private static String layerQn(Node node) {
        return node instanceof NodeReference ? ((NodeReference)node).layerQualifiedName() : ((NodeImpl)node).layerQualifiedName();
    }

    private void addAnnotationAssumptions(Node node, FrameBuilder assumptions) {
        node.annotations().forEach(tag -> assumptions.add("assumption", tag.name().toLowerCase()));
        for (Tag tag2 : node.flags()) {
            if (tag2.equals((Object)Tag.Terminal)) {
                assumptions.add("assumption", Tag.Instance.name());
                continue;
            }
            if (tag2.equals((Object)Tag.Feature)) {
                assumptions.add("assumption", Tag.Feature.name());
                continue;
            }
            if (tag2.equals((Object)Tag.Component)) {
                assumptions.add("assumption", Format.capitalize(Tag.Component.name()));
                continue;
            }
            if (!tag2.equals((Object)Tag.Volatile)) continue;
            assumptions.add("assumption", Format.capitalize(Tag.Volatile.name()));
        }
        if (node.type().startsWith("MetaAspect")) {
            assumptions.add("assumption", Tag.Aspect.name());
        }
        if (node.isAspect()) {
            assumptions.add("assumption", (Object)Tag.Terminal);
        }
    }

    private FrameBuilder buildComponentConstraints(Node container) {
        FrameBuilder constraints = new FrameBuilder("constraints");
        this.addComponentsConstraints(constraints, container);
        return constraints;
    }

    private void addComponentsConstraints(FrameBuilder constraints, Node container) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        this.createComponentsConstraints(container, frames);
        frames.forEach(frame -> constraints.add("constraint", frame));
    }

    private void createComponentsConstraints(Node node, List<Frame> frames) {
        node.components().stream().filter(c -> this.componentCompliant(node, (Node)c)).forEach(c -> {
            if (c.isMetaAspect()) {
                this.createMetaAspectComponentConstraint(frames, (Node)c);
            } else if (!c.isSub()) {
                this.createComponentConstraint(frames, (Node)c);
            }
        });
    }

    private boolean componentCompliant(Node container, Node node) {
        return !node.isAspect() && (!(container instanceof NodeRoot) || this.rootCompliant(node));
    }

    private boolean rootCompliant(Node c) {
        return !c.is(Tag.Component) && !c.is(Tag.Feature) && (!c.isTerminal() || !c.into(Tag.Component) && !c.into(Tag.Feature));
    }

    private void createMetaAspectComponentConstraint(List<Frame> frames, Node node) {
        if (!node.isMetaAspect() || node.isAbstract()) {
            return;
        }
        Node target = node.container();
        if (target.isAbstract()) {
            for (Node child : target.children()) {
                FrameBuilder builder = new FrameBuilder("constraint", "component").add("type", node.name() + FacetSeparator + child.qualifiedName());
                builder.add("size", node.isTerminal() && Configuration.Artifact.Model.Level.Product.compareLevelWith(this.level) > 0 ? this.transformSizeRuleOfTerminalNode(node) : this.createRulesFrames(node.container().rulesOf(node)));
                this.addTags(node, builder);
                frames.add(builder.toFrame());
            }
        } else {
            this.createComponentConstraint(frames, node);
        }
    }

    private void createComponentConstraint(List<Frame> frames, Node component) {
        List<Node> candidates = this.collectCandidates(component);
        Size size = component.container().sizeOf(component);
        List<Rule> allRules = component.container().rulesOf(component).stream().distinct().collect(Collectors.toList());
        if ((size.isSingle() || size.isRequired() || component.isReference()) && candidates.size() > 1) {
            FrameBuilder oneOfBuilder = this.createOneOf(candidates, allRules);
            if (!component.isAbstract() && !candidates.contains(component)) {
                oneOfBuilder.add("constraint", this.createComponentConstraint(component, allRules));
            }
            if (!component.isSub()) {
                frames.add(oneOfBuilder.toFrame());
            }
        } else {
            frames.addAll(candidates.stream().filter(c -> this.componentCompliant(c.container(), (Node)c)).map(c -> this.createComponentConstraint((Node)c, allRules)).collect(Collectors.toList()));
        }
    }

    private Frame createComponentConstraint(Node component, List<Rule> rules) {
        FrameBuilder builder = new FrameBuilder("constraint", "component").add("type", this.name(component));
        if (this.isTerminal(component)) {
            builder.add("size", this.transformSizeRuleOfTerminalNode(component));
        } else {
            builder.add("size", this.createRulesFrames(rules));
        }
        this.addTags(component, builder);
        return builder.toFrame();
    }

    private boolean isTerminal(Node component) {
        return component.isTerminal() && !this.isInTerminal(component) && Configuration.Artifact.Model.Level.Product.compareLevelWith(this.level) > 0;
    }

    private String name(Node node) {
        return node instanceof NodeReference ? ((NodeReference)node).destination().qualifiedName() : node.qualifiedName();
    }

    private FrameBuilder createOneOf(Collection<Node> candidates, List<Rule> rules) {
        FrameBuilder builder = new FrameBuilder("oneOf", "constraint");
        builder.add("rule", this.createRulesFrames(rules));
        for (Node candidate : candidates) {
            builder.add("constraint", this.createComponentConstraint(candidate, rules));
        }
        return builder;
    }

    private Frame[] createRulesFrames(List<Rule> rules) {
        return (Frame[])rules.stream().map(rule -> rule instanceof NodeCustomRule ? this.buildCustomRuleFrame((NodeCustomRule)rule) : new FrameBuilder().append(rule).toFrame()).toArray(Frame[]::new);
    }

    private Frame buildCustomRuleFrame(NodeCustomRule rule) {
        return new FrameBuilder("rule", "customRule").add("qn", rule.loadedClass().getName()).toFrame();
    }

    private boolean isInTerminal(Node component) {
        return component.container().isTerminal();
    }

    private Frame transformSizeRuleOfTerminalNode(Node component) {
        Size rule = component.container().sizeOf(component);
        Size size = new Size(0, rule.max(), rule);
        return new FrameBuilder().append(size).toFrame();
    }

    private void addTags(Node node, FrameBuilder frame) {
        Set tags = node.annotations().stream().map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
        node.flags().stream().filter(f -> !f.equals((Object)Tag.Decorable) && !Tag.Required.equals(f)).forEach(tag -> tags.add(this.convertTag((Tag)((Object)tag))));
        frame.add("tags", tags.toArray(new Object[0]));
    }

    private List<Node> collectCandidates(Node node) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        if (node.isAnonymous() || node.is(Tag.Instance)) {
            return new ArrayList<Node>(nodes);
        }
        if (!node.isAbstract()) {
            nodes.add(node);
        }
        this.getNonAbstractChildren(node, nodes);
        return new ArrayList<Node>(nodes);
    }

    private void getNonAbstractChildren(Node node, Set<Node> nodes) {
        for (Node child : node.children()) {
            if (child.isAbstract()) {
                this.getNonAbstractChildren(child, nodes);
                continue;
            }
            if (!child.container().equals(node.container()) && !node.isReference()) continue;
            nodes.add(child);
        }
    }

    private String convertTag(Tag tag) {
        if (tag.equals((Object)Tag.Terminal)) {
            return Tag.Instance.name();
        }
        return tag.name();
    }

    private List<Tag> annotations(Constraint constraint) {
        return ((Constraint.Component)constraint).annotations();
    }

    private boolean is(List<Tag> annotations, Tag tag) {
        return annotations.contains((Object)tag);
    }
}

