/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.codegeneration.language;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.codegeneration.language.LanguageModelAdapter;
import io.intino.magritte.builder.codegeneration.language.LanguageTemplate;
import io.intino.magritte.builder.core.CompilerConfiguration;
import io.intino.magritte.builder.model.Model;
import io.intino.magritte.builder.utils.Format;
import java.util.Collection;
import java.util.Iterator;

class LanguageCreator {
    private final CompilerConfiguration conf;
    private final Collection<Model> models;

    LanguageCreator(CompilerConfiguration conf, Collection<Model> models) {
        this.conf = conf;
        this.models = models;
    }

    public String create() {
        LanguageTemplate template = new LanguageTemplate();
        template.add("string", Format.string());
        template.add("reference", Format.reference());
        template.add("toCamelCase", Format.toCamelCase());
        template.add("withDollar", Format.withDollar());
        Iterator<Model> iterator = this.models.iterator();
        FrameBuilder builder = this.createFrame(iterator.next());
        iterator.forEachRemaining(m -> this.merge(builder, this.createFrame((Model)m)));
        Frame frame = builder.toFrame();
        return template.render(frame);
    }

    private void merge(FrameBuilder main, FrameBuilder newBuilder) {
        newBuilder.toFrame().frames("node").forEachRemaining(n -> main.add("node", n));
    }

    private FrameBuilder createFrame(Model model) {
        FrameBuilder builder = new FrameBuilder();
        CompilerConfiguration.Language language = this.conf.model().language();
        builder.put(Model.class, new LanguageModelAdapter(this.conf.model().outDsl(), this.conf.getLocale(), model.language(), this.conf.model().level(), this.conf.workingPackage(), language.generationPackage()));
        return builder.append(model);
    }
}

