/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte;

import io.intino.magritte.Language;
import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.semantics.Constraint;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Resolver {
    private final Language language;

    public Resolver(Language language) {
        this.language = language;
    }

    public static String shortType(String absoluteType) {
        return absoluteType.contains(".") ? absoluteType.substring(absoluteType.lastIndexOf(46) + 1) : absoluteType;
    }

    public void resolve(Node node) {
        if (this.context(node) == null) {
            return;
        }
        this.resolveNode(node);
    }

    private void resolveNode(Node node) {
        this.resolve(this.context(node));
        List<Constraint> contextConstraints = this.contextConstraints(node);
        if (contextConstraints == null) {
            return;
        }
        for (Constraint constraint2 : this.components(contextConstraints)) {
            if (!this.checkComponentConstraint(node, constraint2)) continue;
            return;
        }
        this.metaAspects(contextConstraints).forEach(constraint -> this.checkMetaAspectConstraint(node, (Constraint.MetaAspect)constraint));
    }

    private List<Constraint> contextConstraints(Node node) {
        List<Constraint> constraints;
        if (node == null || this.language == null) {
            return Collections.emptyList();
        }
        Node context = this.context(node);
        List<Constraint> list = constraints = context != null && context.type() != null ? this.language.constraints(context.type()) : null;
        if (constraints != null && (this.isComponent(constraints, node) || this.isMetaAspect(constraints, node))) {
            return constraints;
        }
        return this.findInAspects(node);
    }

    private boolean isMetaAspect(List<Constraint> constraints, Node node) {
        return this.metaAspects(constraints).stream().anyMatch(constraint -> Resolver.shortType(constraint.type()).equals(node.type()));
    }

    private boolean isComponent(List<Constraint> context, Node node) {
        return context.stream().anyMatch(constraint -> constraint instanceof Constraint.Component && (Resolver.shortType(((Constraint.Component)constraint).type()).equals(node.type()) || ((Constraint.Component)constraint).type().equals(node.type()) || this.isOneOf((Constraint.Component)constraint, node.type())));
    }

    private List<Constraint.Component> components(List<Constraint> context) {
        return context.stream().filter(c -> c instanceof Constraint.Component).map(c -> (Constraint.Component)c).collect(Collectors.toList());
    }

    private List<Constraint.MetaAspect> metaAspects(List<Constraint> context) {
        return context.stream().filter(c -> c instanceof Constraint.MetaAspect).map(c -> (Constraint.MetaAspect)c).collect(Collectors.toList());
    }

    private boolean isOneOf(Constraint.Component allow, String type) {
        if (!(allow instanceof Constraint.OneOf)) {
            return false;
        }
        return ((Constraint.OneOf)allow).components().stream().anyMatch(one -> one.type().endsWith("." + type) || one.type().equals(type));
    }

    private List<Constraint> findInAspects(Node node) {
        Node context = this.context(node);
        for (Aspect aspect : context.appliedAspects()) {
            List<Constraint> constraints = this.language.constraints(aspect.fullType());
            if (constraints == null || !this.isComponent(constraints, node)) continue;
            return constraints;
        }
        return null;
    }

    private void resolveAspects(Node node) {
        for (Aspect aspect : node.appliedAspects()) {
            Constraint.Aspect constraint = this.language.constraints(node.type()).stream().filter(c -> c instanceof Constraint.Aspect && this.simpleType((Constraint.Aspect)c).equals(aspect.type())).findFirst().orElse(null);
            if (constraint == null) continue;
            aspect.fullType(constraint.type());
        }
    }

    private String simpleType(Constraint.Aspect aspect) {
        return aspect.type().contains(".") ? aspect.type().substring(aspect.type().lastIndexOf(".") + 1) : aspect.type();
    }

    private boolean checkComponentConstraint(Node node, Constraint constraint) {
        if (!(constraint instanceof Constraint.Component)) {
            return false;
        }
        if (constraint instanceof Constraint.OneOf) {
            return this.checkAllowOneOf(node, constraint);
        }
        return this.checkAsComponent(node, (Constraint.Component)constraint);
    }

    private void checkMetaAspectConstraint(Node node, Constraint.MetaAspect constraint) {
        if (node.type() != null && Resolver.shortType(node.type()).equals(Resolver.shortType(constraint.type()))) {
            node.type(constraint.type());
        }
    }

    private boolean checkAsComponent(Node node, Constraint.Component allow) {
        String absoluteType = allow.type();
        if (node.type() != null && Resolver.shortType(node.type()).equals(Resolver.shortType(absoluteType))) {
            node.type(absoluteType);
            node.metaTypes(this.language.types(absoluteType));
            this.resolveAspects(node);
            return true;
        }
        return false;
    }

    private boolean checkAllowOneOf(Node node, Constraint allow) {
        for (Constraint constraint : ((Constraint.OneOf)allow).components()) {
            String absoluteType = ((Constraint.Component)constraint).type();
            if (node.type() == null || !Resolver.shortType(node.type()).equals(Resolver.shortType(absoluteType))) continue;
            node.type(absoluteType);
            node.metaTypes(this.language.types(absoluteType));
            this.resolveAspects(node);
            return true;
        }
        return false;
    }

    public Node context(Node node) {
        if (node == null) {
            return null;
        }
        return node.container();
    }
}

