/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio.model;

import io.intino.legio.model.LegioGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Repository
extends Layer
implements Terminal {
    protected String identifier;
    protected List<Type> typeList = new ArrayList<Type>();
    protected Release release;
    protected Snapshot snapshot;

    public Repository(Node node) {
        super(node);
    }

    public String identifier() {
        return this.identifier;
    }

    public Repository identifier(String value) {
        this.identifier = value;
        return this;
    }

    public List<Type> typeList() {
        return Collections.unmodifiableList(this.typeList);
    }

    public Type type(int index) {
        return this.typeList.get(index);
    }

    public List<Type> typeList(Predicate<Type> predicate) {
        return this.typeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Type type(Predicate<Type> predicate) {
        return this.typeList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Release release() {
        return this.release;
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Type>(this.typeList).forEach(c -> components.add(c.core$()));
        if (this.release != null) {
            components.add(this.release.core$());
        }
        if (this.snapshot != null) {
            components.add(this.snapshot.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("identifier", new ArrayList<String>(Collections.singletonList(this.identifier)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Repository$Type")) {
            this.typeList.add(node.as(Type.class));
        }
        if (node.is("Repository$Release")) {
            this.release = node.as(Release.class);
        }
        if (node.is("Repository$Snapshot")) {
            this.snapshot = node.as(Snapshot.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Repository$Type")) {
            this.typeList.remove(node.as(Type.class));
        }
        if (node.is("Repository$Release")) {
            this.release = null;
        }
        if (node.is("Repository$Snapshot")) {
            this.snapshot = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("identifier")) {
            this.identifier = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("identifier")) {
            this.identifier = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public LegioGraph graph() {
        return this.core$().graph().as(LegioGraph.class);
    }

    public static class Snapshot
    extends Type
    implements Terminal {
        public Snapshot(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public LegioGraph graph() {
            return this.core$().graph().as(LegioGraph.class);
        }
    }

    public static class Release
    extends Type
    implements Terminal {
        public Release(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public LegioGraph graph() {
            return this.core$().graph().as(LegioGraph.class);
        }
    }

    public static abstract class Type
    extends Layer
    implements Terminal {
        protected String url;

        public Type(Node node) {
            super(node);
        }

        public String url() {
            return this.url;
        }

        public Type url(String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = StringLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public LegioGraph graph() {
            return this.core$().graph().as(LegioGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Release release(String url) {
            Release newElement = Repository.this.core$().graph().concept(Release.class).createNode(this.name, Repository.this.core$()).as(Release.class);
            newElement.core$().set(newElement, "url", Collections.singletonList(url));
            return newElement;
        }

        public Snapshot snapshot(String url) {
            Snapshot newElement = Repository.this.core$().graph().concept(Snapshot.class).createNode(this.name, Repository.this.core$()).as(Snapshot.class);
            newElement.core$().set(newElement, "url", Collections.singletonList(url));
            return newElement;
        }
    }
}

