/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio.model;

import io.intino.legio.model.Artifact;
import io.intino.legio.model.Repository;
import io.intino.legio.model.RunConfiguration;
import io.intino.legio.model.Server;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Artifact artifact;
    private List<RunConfiguration> runConfigurationList = new ArrayList<RunConfiguration>();
    private List<Server> serverList = new ArrayList<Server>();
    private List<Repository> repositoryList = new ArrayList<Repository>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Legio");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Legio");
        this.artifact = wrapper.artifact;
        this.runConfigurationList = new ArrayList<RunConfiguration>(wrapper.runConfigurationList);
        this.serverList = new ArrayList<Server>(wrapper.serverList);
        this.repositoryList = new ArrayList<Repository>(wrapper.repositoryList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return this.core$().as(t);
    }

    @Override
    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    @Override
    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public List<RunConfiguration> runConfigurationList() {
        return this.runConfigurationList;
    }

    public List<Server> serverList() {
        return this.serverList;
    }

    public List<Repository> repositoryList() {
        return this.repositoryList;
    }

    public Stream<RunConfiguration> runConfigurationList(Predicate<RunConfiguration> filter) {
        return this.runConfigurationList.stream().filter(filter);
    }

    public RunConfiguration runConfiguration(int index) {
        return this.runConfigurationList.get(index);
    }

    public Stream<Server> serverList(Predicate<Server> filter) {
        return this.serverList.stream().filter(filter);
    }

    public Server server(int index) {
        return this.serverList.get(index);
    }

    public Stream<Repository> repositoryList(Predicate<Repository> filter) {
        return this.repositoryList.stream().filter(filter);
    }

    public Repository repository(int index) {
        return this.repositoryList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Artifact", new Indexer(node -> {
            this.artifact = node.as(Artifact.class);
        }, node -> {
            this.artifact = null;
        }, () -> {
            this.artifact = null;
        }));
        map.put("RunConfiguration", new Indexer(node -> this.runConfigurationList.add(node.as(RunConfiguration.class)), node -> this.runConfigurationList.remove(node.as(RunConfiguration.class)), () -> this.runConfigurationList.clear()));
        map.put("Server", new Indexer(node -> this.serverList.add(node.as(Server.class)), node -> this.serverList.remove(node.as(Server.class)), () -> this.serverList.clear()));
        map.put("Repository", new Indexer(node -> this.repositoryList.add(node.as(Repository.class)), node -> this.repositoryList.remove(node.as(Repository.class)), () -> this.repositoryList.clear()));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void runConfiguration(Predicate<RunConfiguration> filter) {
            new ArrayList<RunConfiguration>(AbstractGraph.this.runConfigurationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void server(Predicate<Server> filter) {
            new ArrayList<Server>(AbstractGraph.this.serverList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void repository(Predicate<Repository> filter) {
            new ArrayList<Repository>(AbstractGraph.this.repositoryList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Artifact artifact(String groupId, String version) {
            Artifact newElement = AbstractGraph.this.graph.createRoot(Artifact.class, this.stash, this.name).a$(Artifact.class);
            newElement.core$().set(newElement, "groupId", Collections.singletonList(groupId));
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public RunConfiguration runConfiguration() {
            RunConfiguration newElement = AbstractGraph.this.graph.createRoot(RunConfiguration.class, this.stash, this.name).a$(RunConfiguration.class);
            return newElement;
        }

        public Server server(Server.Type type) {
            Server newElement = AbstractGraph.this.graph.createRoot(Server.class, this.stash, this.name).a$(Server.class);
            newElement.core$().set(newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Repository repository(String identifier) {
            Repository newElement = AbstractGraph.this.graph.createRoot(Repository.class, this.stash, this.name).a$(Repository.class);
            newElement.core$().set(newElement, "identifier", Collections.singletonList(identifier));
            return newElement;
        }
    }
}

