/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilderContext;
import io.intino.itrules.adapters.DefaultAdapter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FrameBuilder
implements FrameBuilderContext {
    private final List<String> types;
    private final Map<String, List<Frame>> slots;
    private static final Map<String, Primitive> cache = new HashMap<String, Primitive>();
    private Map<Class, Adapter> adapters;
    private Object value;

    public FrameBuilder() {
        this.types = new ArrayList<String>();
        this.slots = new HashMap<String, List<Frame>>();
        this.adapters = new HashMap<Class, Adapter>();
    }

    public FrameBuilder(String ... types) {
        this.types = this.toLowerCase(Arrays.asList(types));
        this.slots = new HashMap<String, List<Frame>>();
        this.adapters = new HashMap<Class, Adapter>();
    }

    public static void cleanCache() {
        cache.clear();
    }

    public static FrameBuilder from(FrameBuilderContext context) {
        FrameBuilder builder = new FrameBuilder();
        if (context instanceof FrameBuilder) {
            builder.adapters = ((FrameBuilder)context).adapters;
        }
        if (context instanceof WrapBuilder) {
            builder.adapters = ((WrapBuilder)((WrapBuilder)context)).builder.adapters;
        }
        return builder;
    }

    private static boolean isPrimitive(Object object) {
        return FrameBuilder.isPrimitive(object.getClass());
    }

    private static boolean isPrimitive(Class aClass) {
        return aClass.isPrimitive() || String.class.isAssignableFrom(aClass) || Byte.class.isAssignableFrom(aClass) || Short.class.isAssignableFrom(aClass) || Integer.class.isAssignableFrom(aClass) || Long.class.isAssignableFrom(aClass) || Float.class.isAssignableFrom(aClass) || Double.class.isAssignableFrom(aClass) || Boolean.class.isAssignableFrom(aClass) || Temporal.class.isAssignableFrom(aClass) || Enum.class.isAssignableFrom(aClass) || Character.class.isAssignableFrom(aClass);
    }

    private List<String> toLowerCase(List<String> list) {
        return list.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public boolean is(String type) {
        return this.types.contains(type);
    }

    @Override
    public FrameBuilder add(String type) {
        this.types.add(type.toLowerCase());
        return this;
    }

    @Override
    public boolean contains(String slot) {
        return this.slots.containsKey(slot.toLowerCase());
    }

    @Override
    public int slots() {
        return this.slots.size();
    }

    @Override
    public FrameBuilder add(String slot, Object object) {
        if (object == null) {
            return this;
        }
        if (object.getClass().isArray()) {
            this.objectsIn(object).forEach(o -> this.get(slot).add(this.frameOf(o)));
        } else {
            this.get(slot).add(this.frameOf(object));
        }
        return this;
    }

    private Stream<Object> objectsIn(Object object) {
        return Arrays.stream((Object[])object);
    }

    public FrameBuilder append(Object object) {
        this.addValueOf(object);
        this.addTypesOf(object);
        this.addSlotsOf(object);
        return this;
    }

    public FrameBuilder append(Frame frame) {
        return this;
    }

    public <T> FrameBuilder put(Class<T> aClass, Adapter<T> adapter) {
        this.adapters.put(aClass, adapter);
        return this;
    }

    public FrameBuilder put(Map<Class, Adapter> adapters) {
        this.adapters = adapters;
        return this;
    }

    public Frame toFrame() {
        return this.value != null ? new Primitive(this.value) : new Composite(this.types, this.slots);
    }

    private void addValueOf(Object object) {
        if (!FrameBuilder.isPrimitive(object)) {
            return;
        }
        this.value = object;
    }

    private void addTypesOf(Object object) {
        if (FrameBuilder.isPrimitive(object)) {
            return;
        }
        this.types.addAll(this.typesOf(object));
    }

    private void addSlotsOf(Object object) {
        if (FrameBuilder.isPrimitive(object)) {
            return;
        }
        this.adapterFor(object).adapt(object, this.context());
    }

    private List<Frame> get(String slot) {
        if (!this.slots.containsKey(slot = slot.toLowerCase())) {
            this.slots.put(slot, new ArrayList());
        }
        return this.slots.get(slot);
    }

    private Frame frameOf(Object object) {
        if (FrameBuilder.isPrimitive(object)) {
            if (cache.containsKey(object.toString())) {
                return cache.get(object.toString());
            }
            Primitive primitive = new Primitive(object);
            cache.put(object.toString(), primitive);
            return primitive;
        }
        if (object instanceof Frame) {
            return (Frame)object;
        }
        if (object instanceof FrameBuilder) {
            return ((FrameBuilder)object).toFrame();
        }
        return this.build(object);
    }

    private Frame build(Object object) {
        return new FrameBuilder().put(this.adapters).append(object).toFrame();
    }

    private Adapter<Object> adapterFor(Object object) {
        List adapters = this.classesOf(object).stream().map(this::adapterFor).collect(Collectors.toList());
        for (Adapter adapter : adapters) {
            if (adapter == null) continue;
            return adapter;
        }
        return new DefaultAdapter<Object>();
    }

    private Adapter adapterFor(Class aClass) {
        return this.adapters.getOrDefault(aClass, null);
    }

    private List<String> typesOf(Object object) {
        return this.classesOf(object).stream().map(Class::getSimpleName).map(String::toLowerCase).collect(Collectors.toList());
    }

    private List<Class> classesOf(Object object) {
        return this.classesOf(object.getClass());
    }

    private FrameBuilderContext context() {
        return new WrapBuilder();
    }

    private List<Class> classesOf(Class aClass) {
        ArrayList<Class> types = new ArrayList<Class>();
        if (aClass == null) {
            return types;
        }
        if (!aClass.getSimpleName().isEmpty()) {
            types.add(aClass);
        }
        types.addAll(this.classesOf(aClass.getSuperclass()));
        types.addAll(this.interfacesOf(aClass));
        return types;
    }

    private List<Class> interfacesOf(Class aClass) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        for (Class<?> aInterface : aClass.getInterfaces()) {
            interfaces.addAll(this.classesOf(aInterface));
        }
        return interfaces;
    }

    private class WrapBuilder
    implements FrameBuilderContext {
        private final FrameBuilder builder;

        private WrapBuilder() {
            this.builder = FrameBuilder.this;
        }

        @Override
        public FrameBuilderContext add(String type) {
            this.builder.add(type);
            return this;
        }

        @Override
        public boolean is(String type) {
            return this.builder.is(type);
        }

        @Override
        public FrameBuilderContext add(String slot, Object objects) {
            this.builder.add(slot, objects);
            return this;
        }

        @Override
        public boolean contains(String slot) {
            return this.builder.contains(slot);
        }

        @Override
        public int slots() {
            return this.builder.slots();
        }
    }

    static class Primitive
    implements Frame {
        private final Object value;
        private final String type;
        private static final Map<Class, String> types = new HashMap<Class, String>();

        public Primitive(Object value) {
            this.value = value;
            this.type = this.typeOf(value.getClass());
        }

        private String typeOf(Class<?> aClass) {
            if (!types.containsKey(aClass)) {
                types.put(aClass, aClass.getSimpleName().toLowerCase());
            }
            return types.get(aClass);
        }

        @Override
        public boolean is(String type) {
            return type.equals(this.type);
        }

        @Override
        public Iterator<Frame> frames(String slot) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean contains(String slot) {
            return false;
        }

        @Override
        public Object value() {
            return this.value;
        }

        public int hashCode() {
            return this.type.hashCode() + 31 * (this.value != null ? this.value.hashCode() : 0);
        }

        public String toString() {
            return "Frame <" + this.value + ": " + this.type + ">";
        }
    }

    private static class Composite
    implements Frame {
        private final List<String> types;
        private final Map<String, List<Frame>> slots;

        public Composite(List<String> types, Map<String, List<Frame>> slots) {
            this.types = types;
            this.slots = slots;
        }

        @Override
        public boolean is(String type) {
            return this.types.stream().anyMatch(t -> t.equals(type));
        }

        @Override
        public boolean contains(String slot) {
            return this.slots.containsKey(slot.toLowerCase());
        }

        @Override
        public Iterator<Frame> frames(String slot) {
            return this.contains(slot) ? this.slots.get(slot.toLowerCase()).iterator() : Collections.emptyIterator();
        }

        @Override
        public Object value() {
            return null;
        }

        public int hashCode() {
            int h = this.types.hashCode();
            for (String slot : this.sortedSlots()) {
                h = 31 * h + this.hashCodeOf(slot) >>> 1;
            }
            return h;
        }

        private List<String> sortedSlots() {
            ArrayList<String> list = new ArrayList<String>(this.slots.keySet());
            list.sort(Comparator.naturalOrder());
            return list;
        }

        private int hashCodeOf(String slot) {
            Iterator<Frame> frames = this.frames(slot);
            int h = slot.hashCode();
            while (frames.hasNext()) {
                Frame frame = frames.next();
                h = 31 * h + frame.hashCode() >>> 1;
            }
            return h;
        }

        public String toString() {
            return "Frame <" + String.join((CharSequence)",", this.slots.keySet()) + ">";
        }
    }
}

